/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class MaidFeedAnimalTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private final int maxAnimalCount;
    private Animal feedEntity = null;
    private long chatBubbleKey = -1L;

    public MaidFeedAnimalTask(float speedModifier, int maxAnimalCount) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.maxAnimalCount = maxAnimalCount;
        this.setMaxCheckRate(12);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.feedEntity = null;
        long animalCount = this.getEntities(maid).m_186128_(e -> maid.m_21444_(e.m_20183_())).filter(Entity::m_6084_).filter(e -> e instanceof Animal).count();
        if (animalCount < (long)this.maxAnimalCount) {
            this.getEntities(maid).m_186128_(e -> maid.m_21444_(e.m_20183_())).filter(Entity::m_6084_).filter(e -> e instanceof Animal).filter(e -> ((Animal)e).m_146764_() == 0).filter(e -> ((Animal)e).m_5957_()).filter(e -> ItemsUtil.isStackIn((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((Animal)((Animal)e)).m_6898_(arg_0))).filter(maid::canPathReach).findFirst().ifPresent(e -> {
                this.feedEntity = (Animal)e;
                BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0);
            });
            if (this.feedEntity != null && this.feedEntity.m_19950_((Entity)maid, 2.0)) {
                ItemStack food = ItemsUtil.getStack((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((Animal)this.feedEntity).m_6898_(arg_0));
                if (!food.m_41619_()) {
                    food.m_41774_(1);
                    maid.m_6674_(InteractionHand.MAIN_HAND);
                    this.feedEntity.m_27595_(null);
                    LivingEntity livingEntity = maid.m_269323_();
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_feed_animal");
                    }
                }
                this.feedEntity = null;
            }
        } else {
            this.chatBubbleKey = maid.getChatBubbleManager().addTextChatBubbleIfTimeout("chat_bubble.touhou_little_maid.inner.feed_animal.max_number", this.chatBubbleKey);
        }
    }

    private NearestVisibleLivingEntities getEntities(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
    }
}

