/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class MaidShootTargetAnyItemTask
extends Behavior<EntityMaid> {
    private final int attackCooldown;
    private final int chargeDurationTick;
    private final Predicate<ItemStack> weaponTest;
    private int attackTime = -1;
    private int seeTime;
    private int swingTime;

    public MaidShootTargetAnyItemTask(int attackCooldown, int chargeDurationTick, Predicate<ItemStack> weaponTest) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
        this.attackCooldown = attackCooldown;
        this.chargeDurationTick = chargeDurationTick;
        this.weaponTest = weaponTest;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        Optional memory = owner.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        if (memory.isPresent()) {
            LivingEntity target = (LivingEntity)memory.get();
            return owner.m_21093_(this.weaponTest) && owner.canSee(target);
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void tick(ServerLevel worldIn, EntityMaid owner, long gameTime) {
        owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> {
            boolean itemCanNotUse;
            boolean seeTimeMoreThanZero;
            owner.m_21563_().m_24946_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSee = owner.canSee((LivingEntity)target);
            boolean bl = seeTimeMoreThanZero = this.seeTime > 0;
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            boolean bl2 = itemCanNotUse = owner.m_21205_().m_41779_() <= 0;
            if (itemCanNotUse) {
                this.tickItemCanNotUse(owner, (LivingEntity)target, canSee);
            } else {
                this.tickItemCanUse(owner, (LivingEntity)target, canSee);
            }
        });
    }

    private void tickItemCanUse(EntityMaid owner, LivingEntity target, boolean canSee) {
        if (owner.m_6117_()) {
            int ticksUsingItem;
            if (!canSee && this.seeTime < -60) {
                owner.m_5810_();
            } else if (canSee && (ticksUsingItem = owner.m_21252_()) >= this.chargeDurationTick) {
                owner.m_5810_();
                int powerTime = Math.max(ticksUsingItem, 20);
                owner.m_6504_(target, BowItem.m_40661_((int)powerTime));
                this.attackTime = this.attackCooldown;
            }
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            owner.m_6672_(InteractionHand.MAIN_HAND);
        }
    }

    private void tickItemCanNotUse(EntityMaid owner, LivingEntity target, boolean canSee) {
        if (owner.isSwingingArms()) {
            if (!canSee && this.seeTime < -60) {
                owner.setSwingingArms(false);
                this.swingTime = 0;
            } else if (canSee && this.swingTime >= this.chargeDurationTick) {
                int powerTime = Math.max(this.swingTime, 20);
                owner.m_6504_(target, BowItem.m_40661_((int)powerTime));
                this.attackTime = this.attackCooldown;
                owner.setSwingingArms(false);
                this.swingTime = 0;
            }
            ++this.swingTime;
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            owner.setSwingingArms(true);
        }
    }

    protected void stop(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.seeTime = 0;
        this.attackTime = -1;
        this.swingTime = 0;
        entityIn.m_5810_();
    }
}

