/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg;

import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPacketReader;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPacketWriter;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPage;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggStreamListener;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggStreamReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class OggFile
implements Closeable {
    private InputStream inp;
    private OutputStream out;
    private boolean writing = true;
    private Set<Integer> seenSIDs = new HashSet<Integer>();

    public OggFile(OutputStream output) {
        this.out = output;
        this.writing = true;
    }

    public OggFile(InputStream input) {
        this.inp = input;
        this.writing = false;
    }

    public OggFile(InputStream input, OggStreamListener listener) throws IOException {
        this(input);
        HashMap<Integer, OggStreamReader[]> readers = new HashMap<Integer, OggStreamReader[]>();
        OggPacketReader reader = this.getPacketReader();
        OggPacket packet = null;
        while ((packet = reader.getNextPacket()) != null) {
            OggStreamReader[] streams;
            if (packet.isBeginningOfStream()) {
                streams = listener.processNewStream(packet.getSid(), packet.getData());
                if (streams != null && streams.length > 0) {
                    readers.put(packet.getSid(), streams);
                }
            } else {
                streams = (OggStreamReader[])readers.get(packet.getSid());
                if (streams != null) {
                    for (OggStreamReader r : streams) {
                        r.processPacket(packet);
                    }
                }
            }
            if (!packet.isEndOfStream()) continue;
            listener.processStreamEnd(packet.getSid());
        }
    }

    public void close() throws IOException {
        if (this.inp != null) {
            this.inp.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    public OggPacketReader getPacketReader() {
        if (this.writing || this.inp == null) {
            throw new IllegalStateException("Can only read from a file opened with an InputStream");
        }
        return new OggPacketReader(this.inp);
    }

    public OggPacketWriter getPacketWriter() {
        return this.getPacketWriter(this.getUnusedSerialNumber());
    }

    public OggPacketWriter getPacketWriter(int sid) {
        if (!this.writing) {
            throw new IllegalStateException("Can only write to a file opened with an OutputStream");
        }
        this.seenSIDs.add(sid);
        return new OggPacketWriter(this, sid);
    }

    protected synchronized void writePages(OggPage[] pages) throws IOException {
        for (OggPage page : pages) {
            page.writeHeader(this.out);
            this.out.write(page.getData());
        }
        this.out.flush();
    }

    protected int getUnusedSerialNumber() {
        int sid;
        while (this.seenSIDs.contains(sid = (int)(Math.random() * 32767.0))) {
        }
        return sid;
    }
}

