/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.skeleton;

import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.HighLevelOggStreamPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.IOUtils;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.skeleton.SkeletonFisbone;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.skeleton.SkeletonFishead;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.skeleton.SkeletonKeyFramePacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.skeleton.SkeletonPacket;

public class SkeletonPacketFactory
extends HighLevelOggStreamPacket {
    public static boolean isSkeletonStream(OggPacket firstPacket) {
        if (!firstPacket.isBeginningOfStream()) {
            return false;
        }
        return SkeletonPacketFactory.isSkeletonSpecial(firstPacket);
    }

    protected static boolean isSkeletonSpecial(OggPacket packet) {
        byte[] d = packet.getData();
        if (d.length < 52) {
            return false;
        }
        if (IOUtils.byteRangeMatches(SkeletonPacket.MAGIC_FISHEAD_BYTES, d, 0)) {
            return true;
        }
        return IOUtils.byteRangeMatches(SkeletonPacket.MAGIC_FISBONE_BYTES, d, 0);
    }

    public static SkeletonPacket create(OggPacket packet) {
        if (SkeletonPacketFactory.isSkeletonSpecial(packet)) {
            byte type = packet.getData()[3];
            switch (type) {
                case 104: {
                    return new SkeletonFishead(packet);
                }
                case 98: {
                    return new SkeletonFisbone(packet);
                }
            }
        }
        return new SkeletonKeyFramePacket(packet);
    }
}

