/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.parser.ast;

import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.Expression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.ExpressionVisitor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class UnaryExpression
implements Expression {
    private final Op op;
    private final Expression expression;

    public UnaryExpression(@NotNull Op op, @NotNull Expression expression) {
        this.op = Objects.requireNonNull(op, "op");
        this.expression = Objects.requireNonNull(expression, "expression");
    }

    @NotNull
    public Op op() {
        return this.op;
    }

    @NotNull
    public Expression expression() {
        return this.expression;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitUnary(this);
    }

    public String toString() {
        return "Unary(" + this.op + ")(" + this.expression + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnaryExpression that = (UnaryExpression)o;
        if (this.op != that.op) {
            return false;
        }
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        int result = this.op.hashCode();
        result = 31 * result + this.expression.hashCode();
        return result;
    }

    public static enum Op {
        LOGICAL_NEGATION(2800),
        ARITHMETICAL_NEGATION(2800),
        PLUS(2800),
        RETURN(-1);

        final int precedence;

        private Op(int precedence) {
            this.precedence = precedence;
        }

        public int precedence() {
            return this.precedence;
        }
    }
}

