/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SaveSwitcherDataMessage {
    private final BlockPos pos;
    private final List<TileEntityModelSwitcher.ModeInfo> modeInfos;

    public SaveSwitcherDataMessage(BlockPos pos, List<TileEntityModelSwitcher.ModeInfo> modeInfos) {
        this.pos = pos;
        this.modeInfos = modeInfos;
    }

    public static void encode(SaveSwitcherDataMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130130_(message.modeInfos.size());
        for (TileEntityModelSwitcher.ModeInfo info : message.modeInfos) {
            info.toBuf(buf);
        }
    }

    public static SaveSwitcherDataMessage decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int size = buf.m_130242_();
        ArrayList modeInfos = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            modeInfos.add(TileEntityModelSwitcher.ModeInfo.fromBuf(buf));
        }
        return new SaveSwitcherDataMessage(pos, modeInfos);
    }

    public static void handle(SaveSwitcherDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                BlockEntity te;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Level world = sender.m_9236_();
                if (world.m_46749_(message.pos) && (te = world.m_7702_(message.pos)) instanceof TileEntityModelSwitcher) {
                    ((TileEntityModelSwitcher)te).setInfoList(message.modeInfos);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

