/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameEntityBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityWChess
extends TileEntityJoy
implements IBoardGameEntityBlock {
    public static final BlockEntityType<TileEntityWChess> TYPE = BlockEntityType.Builder.m_155273_(TileEntityWChess::new, (Block[])new Block[]{(Block)InitBlocks.WCHESS.get()}).m_58966_(null);
    private static final String CHESS_DATA = "ChessData";
    private static final String CHESS_COUNTER = "ChessCounter";
    private static final String SELECT_CHESS_POINT = "SelectChessPoint";
    private static final String CHECKMATE = "Checkmate";
    private static final String REPEAT = "Repeat";
    private static final String MOVE_NUMBER_LIMIT = "MoveNumberLimit";
    private final Position chessData = new Position();
    private int chessCounter = 0;
    private int selectChessPoint = 0;
    private boolean checkmate = false;
    private boolean repeat = false;
    private boolean moveNumberLimit = false;

    public TileEntityWChess(BlockPos pos, BlockState blockState) {
        super(TYPE, pos, blockState);
        this.chessData.fromFen("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        CompoundTag data = this.getPersistentData();
        data.m_128359_(CHESS_DATA, this.chessData.toFen());
        data.m_128405_(CHESS_COUNTER, this.chessCounter);
        data.m_128405_(SELECT_CHESS_POINT, this.selectChessPoint);
        data.m_128379_(CHECKMATE, this.checkmate);
        data.m_128379_(REPEAT, this.repeat);
        data.m_128379_(MOVE_NUMBER_LIMIT, this.moveNumberLimit);
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag data = this.getPersistentData();
        this.chessCounter = data.m_128451_(CHESS_COUNTER);
        this.selectChessPoint = data.m_128451_(SELECT_CHESS_POINT);
        this.chessData.fromFen(data.m_128461_(CHESS_DATA));
        this.checkmate = data.m_128471_(CHECKMATE);
        this.repeat = data.m_128471_(REPEAT);
        this.moveNumberLimit = data.m_128471_(MOVE_NUMBER_LIMIT);
    }

    public void reset() {
        this.chessCounter = 0;
        this.selectChessPoint = 0;
        this.chessData.fromFen("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
        this.checkmate = false;
        this.repeat = false;
        this.moveNumberLimit = false;
    }

    public Position getChessData() {
        return this.chessData;
    }

    public boolean isCheckmate() {
        return this.checkmate;
    }

    public void setCheckmate(boolean checkmate) {
        this.checkmate = checkmate;
    }

    public boolean isPlayerTurn() {
        return WChessUtil.isPlayer(this.chessData);
    }

    public int getChessCounter() {
        return this.chessCounter;
    }

    public void addChessCounter() {
        ++this.chessCounter;
    }

    public int getSelectChessPoint() {
        return this.selectChessPoint;
    }

    public void setSelectChessPoint(int selectChessPoint) {
        this.selectChessPoint = selectChessPoint;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean isMoveNumberLimit() {
        return this.moveNumberLimit;
    }

    public void setMoveNumberLimit(boolean moveNumberLimit) {
        this.moveNumberLimit = moveNumberLimit;
    }
}

