/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.util.NBTToJson;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public final class EntityCraftingHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String TYPE_TAG = "type";
    private static final String NBT_TAG = "nbt";
    private static final String COPY_TAG = "copy";
    private static final String INGREDIENT_TAG = "ingredient";
    private static final String TAG_TAG = "tag";

    public static Output getEntityData(JsonObject json) {
        try {
            Optional optional = EntityType.m_20632_((String)GsonHelper.m_13906_((JsonObject)json, (String)TYPE_TAG));
            if (optional.isPresent()) {
                JsonElement copyElement;
                EntityType type = (EntityType)optional.get();
                JsonElement nbtElement = json.get(NBT_TAG);
                CompoundTag outputData = new CompoundTag();
                if (nbtElement != null) {
                    outputData = nbtElement.isJsonObject() ? TagParser.m_129359_((String)GSON.toJson(nbtElement)) : TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)nbtElement, (String)NBT_TAG));
                }
                if ((copyElement = json.get(COPY_TAG)) != null && copyElement.isJsonObject()) {
                    JsonObject copyObject = copyElement.getAsJsonObject();
                    Ingredient ingredient = Ingredient.m_43917_((JsonElement)copyObject.get(INGREDIENT_TAG));
                    String tag = null;
                    if (copyObject.has(TAG_TAG) && StringUtils.isNotBlank((CharSequence)copyObject.get(TAG_TAG).getAsString())) {
                        tag = copyObject.get(TAG_TAG).getAsString();
                    }
                    return new Output(type, outputData, ingredient, tag);
                }
                return new Output(type, outputData);
            }
            throw new JsonParseException("Entity Type Tag Not Found");
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
        }
    }

    public static JsonObject writeEntityData(Output output) {
        JsonObject json = new JsonObject();
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey(output.type);
        if (key == null) {
            throw new JsonParseException("Entity Type Not Found: " + output.type);
        }
        json.addProperty(TYPE_TAG, key.toString());
        NBTToJson.getJson((Tag)output.getData()).ifPresent(e -> json.add(NBT_TAG, e));
        if (!output.getCopyInput().m_43947_()) {
            JsonObject copyObject = new JsonObject();
            copyObject.add(INGREDIENT_TAG, output.getCopyInput().m_43942_());
            if (StringUtils.isNotBlank((CharSequence)output.getCopyTag())) {
                copyObject.addProperty(TAG_TAG, output.getCopyTag());
            }
            json.add(COPY_TAG, (JsonElement)copyObject);
        }
        return json;
    }

    public static class Output {
        private final EntityType<?> type;
        private final CompoundTag data;
        private final Ingredient copyInput;
        private final String copyTag;

        public Output(EntityType<?> type, CompoundTag data, Ingredient copyInput, @Nullable String copyTag) {
            this.type = type;
            this.data = data;
            this.copyInput = copyInput;
            this.copyTag = copyTag;
        }

        public Output(EntityType<?> type, CompoundTag data) {
            this(type, data, Ingredient.f_43901_, null);
        }

        public EntityType<?> getType() {
            return this.type;
        }

        public CompoundTag getData() {
            return this.data;
        }

        public Ingredient getCopyInput() {
            return this.copyInput;
        }

        @Nullable
        public String getCopyTag() {
            return this.copyTag;
        }
    }
}

