/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem;

import com.corosus.coroutil.util.CULog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import weather2.IWorldData;
import weather2.Weather;
import weather2.WorldNBTData;
import weather2.config.ConfigStorm;
import weather2.config.WeatherUtilConfig;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.EnumWeatherObjectType;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;
import weather2.weathersystem.storm.WeatherObjectParticleStorm;
import weather2.weathersystem.storm.WeatherObjectSandstormOld;
import weather2.weathersystem.wind.WindManager;

public abstract class WeatherManager
implements IWorldData {
    public final ResourceKey<Level> dimension;
    private final WindManager wind = new WindManager(this);
    private List<WeatherObject> listStormObjects = new ArrayList<WeatherObject>();
    public HashMap<Long, WeatherObject> lookupStormObjectsByID = new HashMap();
    public long lastStormFormed = 0L;
    public long lastSandstormFormed = 0L;
    public long lastSnowstormFormed = 0L;
    public float cloudIntensity = 1.0f;
    public boolean isVanillaRainActiveOnServer = false;
    public boolean isVanillaThunderActiveOnServer = false;
    public int vanillaRainTimeOnServer = 0;
    public float vanillaRainAmountOnServer = 0.0f;
    private HashMap<Long, BlockPos> lookupWeatherBlockDamageDeflector = new HashMap();

    public WeatherManager(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public abstract Level getWorld();

    public void tick() {
        Level world = this.getWorld();
        if (world != null) {
            List<WeatherObject> list = this.getStormObjects();
            for (int i = 0; i < list.size(); ++i) {
                WeatherObject so = list.get(i);
                if (this instanceof WeatherManagerServer && so.isDead) {
                    this.removeStormObject(so.ID);
                    ((WeatherManagerServer)this).syncStormRemove(so);
                    continue;
                }
                if (!so.isDead) {
                    so.tick();
                    continue;
                }
                if (!this.getWorld().f_46443_) continue;
                Weather.dbg("WARNING!!! - detected isDead storm object still in client side list, had to remove storm object with ID " + so.ID + " from client side, wasnt properly isDead via main channels");
                this.removeStormObject(so.ID);
            }
            if (WeatherUtilConfig.listDimensionsWindEffects.contains(this.getWorld().m_46472_().m_135782_().toString())) {
                this.wind.tick();
            }
        }
    }

    public WeatherObjectParticleStorm getClosestParticleStormByIntensity(Vec3 parPos, WeatherObjectParticleStorm.StormType type) {
        return this.getClosestParticleStormByIntensity(parPos, type, false);
    }

    public WeatherObjectParticleStorm getClosestParticleStormByIntensity(Vec3 parPos, WeatherObjectParticleStorm.StormType type, boolean forced) {
        WeatherObjectParticleStorm bestStorm = null;
        double closestDist = 9999999.0;
        List<WeatherObject> listStorms = this.getStormObjects();
        for (int i = 0; i < listStorms.size(); ++i) {
            WeatherObjectParticleStorm sandstorm;
            WeatherObject wo = listStorms.get(i);
            if (!(wo instanceof WeatherObjectParticleStorm) || (sandstorm = (WeatherObjectParticleStorm)wo) == null || sandstorm.isDead || sandstorm.getType() != type) continue;
            double dist = parPos.m_82554_(sandstorm.pos);
            if (!(closestDist > 0.0) || !(dist < closestDist)) continue;
            closestDist = dist;
            bestStorm = sandstorm;
        }
        return bestStorm;
    }

    public void reset() {
        for (int i = 0; i < this.getStormObjects().size(); ++i) {
            WeatherObject so = this.getStormObjects().get(i);
            so.reset();
        }
        this.getStormObjects().clear();
        this.lookupStormObjectsByID.clear();
        this.wind.reset();
    }

    public void tickRender(float partialTick) {
        Level world = this.getWorld();
        if (world != null) {
            try {
                for (int i = 0; i < this.getStormObjects().size(); ++i) {
                    WeatherObject obj = this.getStormObjects().get(i);
                    if (obj == null) continue;
                    obj.tickRender(partialTick);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<WeatherObject> getStormObjects() {
        return this.listStormObjects;
    }

    public StormObject getStormObjectByID(long ID) {
        WeatherObject obj = this.lookupStormObjectsByID.get(ID);
        if (obj instanceof StormObject) {
            return (StormObject)obj;
        }
        return null;
    }

    public void addStormObject(WeatherObject so) {
        if (!this.lookupStormObjectsByID.containsKey(so.ID)) {
            this.listStormObjects.add(so);
            this.lookupStormObjectsByID.put(so.ID, so);
            if (so instanceof StormObject) {
                StormObject stormObject = (StormObject)so;
            }
        } else {
            Weather.dbg("Weather2 WARNING!!! Received new storm create for an ID that is already active! design bug or edgecase with PlayerEvent.Clone, ID: " + so.ID);
        }
    }

    public void removeStormObject(long ID) {
        WeatherObject so = this.lookupStormObjectsByID.get(ID);
        if (so != null) {
            so.remove();
            this.listStormObjects.remove(so);
            this.lookupStormObjectsByID.remove(ID);
            if (so instanceof StormObject) {
                StormObject stormObject = (StormObject)so;
            }
        } else {
            Weather.dbg("error looking up storm ID on server for removal: " + ID + " - lookup count: " + this.lookupStormObjectsByID.size() + " - last used ID: " + WeatherObject.lastUsedStormID);
        }
    }

    public StormObject getClosestStormAny(Vec3 parPos, double maxDist) {
        return this.getClosestStorm(parPos, maxDist, -1, -1, true);
    }

    public StormObject getClosestStorm(Vec3 parPos, double maxDist, int severityFlagMin) {
        return this.getClosestStorm(parPos, maxDist, severityFlagMin, -1, false);
    }

    public StormObject getClosestStorm(Vec3 parPos, double maxDist, int severityFlagMin, int severityFlagMax, boolean orRain) {
        StormObject closestStorm = null;
        double closestDist = Double.MAX_VALUE;
        List<WeatherObject> listStorms = this.getStormObjects();
        for (int i = 0; i < listStorms.size(); ++i) {
            double dist;
            StormObject storm;
            WeatherObject wo = listStorms.get(i);
            if (!(wo instanceof StormObject) || (storm = (StormObject)wo) == null || storm.isDead || !((dist = storm.pos.m_82554_(parPos)) < closestDist) || !(dist <= maxDist) || storm.isFirenado || (!storm.attrib_precipitation || !orRain) && (severityFlagMin != -1 && storm.levelCurIntensityStage < severityFlagMin || severityFlagMax != -1 && storm.levelCurIntensityStage > severityFlagMax)) continue;
            closestStorm = storm;
            closestDist = dist;
        }
        return closestStorm;
    }

    public boolean isPrecipitatingAt(BlockPos pos) {
        return this.isPrecipitatingAt(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
    }

    public boolean isPrecipitatingAt(Vec3 parPos) {
        return this.getStormObjects().stream().map(wo -> (StormObject)wo).anyMatch(so -> !so.isDead && so.attrib_precipitation && so.pos.m_82554_(parPos) < (double)so.size);
    }

    public WeatherObjectSandstormOld getClosestSandstorm(Vec3 parPos, double maxDist) {
        WeatherObjectSandstormOld closestStorm = null;
        double closestDist = 9999999.0;
        List<WeatherObject> listStorms = this.getStormObjects();
        for (int i = 0; i < listStorms.size(); ++i) {
            double dist;
            WeatherObjectSandstormOld storm;
            WeatherObject wo = listStorms.get(i);
            if (!(wo instanceof WeatherObjectSandstormOld) || (storm = (WeatherObjectSandstormOld)wo) == null || storm.isDead || !((dist = storm.pos.m_82554_(parPos)) < closestDist) || !(dist <= maxDist)) continue;
            closestStorm = storm;
            closestDist = dist;
        }
        return closestStorm;
    }

    public List<WeatherObject> getSandstormsAround(Vec3 parPos, double maxDist) {
        ArrayList<WeatherObject> storms = new ArrayList<WeatherObject>();
        for (int i = 0; i < this.getStormObjects().size(); ++i) {
            WeatherObject wo = this.getStormObjects().get(i);
            if (!(wo instanceof WeatherObjectSandstormOld)) continue;
            WeatherObjectSandstormOld storm = (WeatherObjectSandstormOld)wo;
            if (storm.isDead || !(storm.pos.m_82554_(parPos) < maxDist)) continue;
            storms.add(storm);
        }
        return storms;
    }

    public List<WeatherObject> getStormsAroundForDeflector(Vec3 parPos, double maxDist) {
        ArrayList<WeatherObject> storms = new ArrayList<WeatherObject>();
        for (int i = 0; i < this.getStormObjects().size(); ++i) {
            WeatherObject wo = this.getStormObjects().get(i);
            if (wo.isDead) continue;
            if (wo instanceof StormObject) {
                StormObject storm = (StormObject)wo;
                if (!(storm.pos.m_82554_(parPos) < maxDist) || (!storm.attrib_precipitation || !ConfigStorm.Storm_Deflector_RemoveRainstorms) && storm.levelCurIntensityStage < ConfigStorm.Storm_Deflector_MinStageRemove) continue;
                storms.add(storm);
                continue;
            }
            if (!(wo instanceof WeatherObjectSandstormOld) || !ConfigStorm.Storm_Deflector_RemoveSandstorms) continue;
            WeatherObjectSandstormOld sandstorm = (WeatherObjectSandstormOld)wo;
            double distToStorm = parPos.m_82554_(sandstorm.pos);
            if (!(distToStorm < maxDist)) continue;
            storms.add(wo);
        }
        return storms;
    }

    public List<WeatherObject> getStormsAround(Vec3 parPos, double maxDist) {
        ArrayList<WeatherObject> storms = new ArrayList<WeatherObject>();
        for (int i = 0; i < this.getStormObjects().size(); ++i) {
            WeatherObject wo = this.getStormObjects().get(i);
            if (wo.isDead) continue;
            if (wo instanceof StormObject) {
                StormObject storm = (StormObject)wo;
                if (!(storm.pos.m_82554_(parPos) < maxDist) || !storm.attrib_precipitation && storm.levelCurIntensityStage <= StormObject.STATE_NORMAL) continue;
                storms.add(storm);
                continue;
            }
            if (!(wo instanceof WeatherObjectSandstormOld)) continue;
            WeatherObjectSandstormOld sandstorm = (WeatherObjectSandstormOld)wo;
            double distToStorm = parPos.m_82554_(sandstorm.pos);
            if (!(distToStorm < maxDist)) continue;
            storms.add(wo);
        }
        return storms;
    }

    @Override
    public CompoundTag save(CompoundTag data) {
        CULog.dbg((String)"WeatherManager save");
        CompoundTag listStormsNBT = new CompoundTag();
        for (int i = 0; i < this.listStormObjects.size(); ++i) {
            WeatherObject obj = this.listStormObjects.get(i);
            obj.getNbtCache().setUpdateForced(true);
            obj.write();
            obj.getNbtCache().setUpdateForced(false);
            listStormsNBT.m_128365_("storm_" + obj.ID, (Tag)obj.getNbtCache().getNewNBT());
        }
        data.m_128365_("stormData", (Tag)listStormsNBT);
        CompoundTag listDeflectorsNBT = new CompoundTag();
        int i = 0;
        for (Map.Entry<Long, BlockPos> entry : this.lookupWeatherBlockDamageDeflector.entrySet()) {
            CULog.dbg((String)("writing out deflector to disk: " + entry.getKey()));
            listDeflectorsNBT.m_128356_("deflector_" + i, entry.getKey().longValue());
            ++i;
        }
        data.m_128365_("deflectorData", (Tag)listDeflectorsNBT);
        data.m_128356_("lastUsedIDStorm", WeatherObject.lastUsedStormID);
        data.m_128356_("lastStormFormed", this.lastStormFormed);
        data.m_128356_("lastSandstormFormed", this.lastSandstormFormed);
        data.m_128356_("lastSnowstormFormed", this.lastSnowstormFormed);
        data.m_128350_("cloudIntensity", this.cloudIntensity);
        data.m_128365_("windMan", (Tag)this.wind.write(new CompoundTag()));
        return data;
    }

    public void read() {
        WorldNBTData worldNBTData = (WorldNBTData)((ServerLevel)this.getWorld()).m_8895_().m_164861_(WorldNBTData::load, WorldNBTData::new, "weather2-weather_data");
        worldNBTData.setDataHandler(this);
        CULog.dbg((String)("weather data: " + worldNBTData.getData()));
        CompoundTag data = worldNBTData.getData();
        this.lastStormFormed = data.m_128454_("lastStormFormed");
        this.lastSandstormFormed = data.m_128454_("lastSandstormFormed");
        this.lastSnowstormFormed = data.m_128454_("lastSnowstormFormed");
        if (data.m_128441_("cloudIntensity")) {
            this.cloudIntensity = data.m_128457_("cloudIntensity");
        }
        WeatherObject.lastUsedStormID = data.m_128454_("lastUsedIDStorm");
        this.wind.read(data.m_128469_("windMan"));
        CompoundTag nbtStorms = data.m_128469_("stormData");
        for (String tagName : nbtStorms.m_128431_()) {
            CompoundTag stormData = nbtStorms.m_128469_(tagName);
            WeatherObject wo = null;
            if (stormData.m_128451_("weatherObjectType") == EnumWeatherObjectType.CLOUD.ordinal()) {
                wo = new StormObject(this);
            } else if (stormData.m_128451_("weatherObjectType") == EnumWeatherObjectType.SAND.ordinal()) {
                wo = new WeatherObjectParticleStorm(this);
                ((WeatherObjectParticleStorm)wo).setType(WeatherObjectParticleStorm.StormType.SANDSTORM);
            } else if (stormData.m_128451_("weatherObjectType") == EnumWeatherObjectType.SNOW.ordinal()) {
                wo = new WeatherObjectParticleStorm(this);
                ((WeatherObjectParticleStorm)wo).setType(WeatherObjectParticleStorm.StormType.SNOWSTORM);
            }
            try {
                wo.getNbtCache().setNewNBT(stormData);
                wo.read();
                wo.getNbtCache().updateCacheFromNew();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.addStormObject(wo);
            ((WeatherManagerServer)this).syncStormNew(wo);
        }
        CompoundTag nbtDeflectors = data.m_128469_("deflectorData");
        for (String tagName : nbtDeflectors.m_128431_()) {
            long hash = nbtDeflectors.m_128454_(tagName);
            if (!BlockPos.m_122022_((long)hash).equals((Object)new BlockPos(0, 0, 0))) {
                CULog.dbg((String)("adding deflector from disk: " + BlockPos.m_122022_((long)hash)));
                this.registerDeflector(BlockPos.m_122022_((long)hash));
                continue;
            }
            CULog.dbg((String)"????????");
        }
        CULog.dbg((String)("reloaded weather objects: " + this.listStormObjects.size()));
    }

    public WindManager getWindManager() {
        return this.wind;
    }

    public HashMap<Long, BlockPos> getLookupWeatherBlockDamageDeflector() {
        return this.lookupWeatherBlockDamageDeflector;
    }

    public void registerDeflector(BlockPos pos) {
        long hash = BlockPos.m_121882_((int)pos.m_123341_(), (int)pos.m_123342_(), (int)pos.m_123343_());
        if (!this.lookupWeatherBlockDamageDeflector.containsKey(hash)) {
            CULog.dbg((String)("adding weather deflector poi at " + pos));
            this.lookupWeatherBlockDamageDeflector.put(hash, pos);
        }
    }

    public void removeDeflector(BlockPos pos) {
        long hash = BlockPos.m_121882_((int)pos.m_123341_(), (int)pos.m_123342_(), (int)pos.m_123343_());
        CULog.dbg((String)("removing weather deflector poi at " + pos));
        this.lookupWeatherBlockDamageDeflector.remove(hash);
    }
}

