/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.client.gui;

import com.talhanation.workers.Main;
import com.talhanation.workers.Translatable;
import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.inventory.MerchantWaypointContainer;
import com.talhanation.workers.network.MessageMerchantAddWayPoint;
import com.talhanation.workers.network.MessageMerchantRemoveWayPoint;
import com.talhanation.workers.network.MessageMerchantReturnTime;
import com.talhanation.workers.network.MessageMerchantSetAutoStartTravel;
import com.talhanation.workers.network.MessageMerchantSetSendInfo;
import com.talhanation.workers.network.MessageMerchantSetTravelSpeed;
import com.talhanation.workers.network.MessageMerchantTravel;
import de.maxhenkel.workers.corelib.inventory.ScreenBase;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class MerchantWaypointScreen
extends ScreenBase<MerchantWaypointContainer> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("workers", "textures/gui/waypoint_list_gui.png");
    private int leftPos;
    private int topPos;
    private int page = 1;
    public static List<BlockPos> waypoints;
    public static List<ItemStack> waypointItems;
    private final MerchantEntity merchant;
    private final Player player;
    private int returnTime;
    public static boolean isStarted;
    public static boolean isReturning;
    public static boolean isStopped;
    public boolean autoStart;
    public boolean sendInfo;
    public int travelSpeedState;
    private static final int fontColor = 0x404040;

    public MerchantWaypointScreen(MerchantWaypointContainer container, Inventory playerInventory, Component title) {
        super(RESOURCE_LOCATION, container, playerInventory, (Component)Component.m_237113_((String)""));
        this.f_97726_ = 211;
        this.f_97727_ = 250;
        this.merchant = (MerchantEntity)container.getWorkerEntity();
        this.player = playerInventory.f_35978_;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.f_97726_) / 2;
        this.topPos = (this.f_96544_ - this.f_97727_) / 2;
        this.returnTime = this.merchant.getReturningTime();
        this.autoStart = this.merchant.getAutoStartTravel();
        this.sendInfo = this.merchant.getSendInfo();
        this.travelSpeedState = this.merchant.getTravelSpeedState();
        this.setButtons();
    }

    private void setButtons() {
        this.m_169413_();
        this.setStartButtons();
        this.setPageButtons();
        this.setWaypointButtons();
        this.setDaysButtons();
        String s = "";
        switch (this.travelSpeedState) {
            case 0: {
                s = "Slow";
                break;
            }
            case 1: {
                s = "Medium";
                break;
            }
            case 2: {
                s = "Fast";
            }
        }
        this.createSetTravelSpeedButton(s);
        String ss = this.autoStart ? "True" : "False";
        this.createSetAutoStartTravelButton(ss);
        String sss = this.sendInfo ? "True" : "False";
        this.createSetSendInfoButton(sss);
    }

    private void createSetTravelSpeedButton(String s) {
        ExtendedButton extendedButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 240, this.topPos + 32, 40, 20, (Component)Component.m_237113_((String)s), button -> {
            ++this.travelSpeedState;
            if (this.travelSpeedState > 2) {
                this.travelSpeedState = 0;
            }
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantSetTravelSpeed(this.merchant.m_20148_(), this.travelSpeedState));
            this.setButtons();
        }));
        extendedButton.m_257544_(Tooltip.m_257550_((Component)Translatable.TOOLTIP_TRAVEL_SPEED));
    }

    private void createSetAutoStartTravelButton(String ss) {
        ExtendedButton extendedButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 240, this.topPos + 57, 40, 20, (Component)Component.m_237113_((String)ss), button -> {
            this.autoStart = !this.autoStart;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantSetAutoStartTravel(this.merchant.m_20148_(), this.autoStart));
            this.setButtons();
        }));
        extendedButton.m_257544_(Tooltip.m_257550_((Component)Translatable.TOOLTIP_AUTO_START_TRAVEL));
    }

    private void createSetSendInfoButton(String ss) {
        ExtendedButton sendInfoButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 240, this.topPos + 82, 40, 20, (Component)Component.m_237113_((String)ss), button -> {
            this.sendInfo = !this.sendInfo;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantSetSendInfo(this.merchant.m_20148_(), this.sendInfo));
            this.setButtons();
        }));
        sendInfoButton.m_257544_(Tooltip.m_257550_((Component)Translatable.TOOLTIP_SEND_INFO));
    }

    public void setStartButtons() {
        ExtendedButton start = this.createTravelStartButton();
        start.f_93623_ = true;
        ExtendedButton stop = this.createTravelStopButton();
        stop.f_93623_ = true;
        ExtendedButton returnButton = this.createTravelReturnButton();
        returnButton.f_93623_ = true;
    }

    public void setPageButtons() {
        Button pageForwardButton = this.createPageForwardButton();
        pageForwardButton.f_93623_ = waypoints.size() > 9;
        ExtendedButton pageBackButton = this.createPageBackButton();
        pageBackButton.f_93623_ = this.page != 1;
    }

    public void setWaypointButtons() {
        Button addButton = this.createAddWaypointButton(this.leftPos + 171, this.topPos + 32);
        Button removeButton = this.createRemoveWaypointButton(this.leftPos + 148, this.topPos + 32);
        addButton.f_93623_ = true;
        removeButton.f_93623_ = true;
        ExtendedButton info = this.createTravelInfoButton(this.leftPos + 215, this.topPos + 32);
    }

    public void setDaysButtons() {
        ExtendedButton addButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 186, this.topPos + 8, 9, 9, (Component)Component.m_237113_((String)"+"), button -> {
            this.returnTime = this.merchant.getReturningTime();
            this.returnTime = this.player.m_6144_() ? (this.returnTime += 5) : ++this.returnTime;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantReturnTime(this.returnTime, this.merchant.m_20148_()));
            this.setButtons();
        }));
        ExtendedButton removeButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 175, this.topPos + 8, 9, 9, (Component)Component.m_237113_((String)"-"), button -> {
            this.returnTime = this.merchant.getReturningTime();
            this.returnTime = this.player.m_6144_() ? (this.returnTime -= 5) : --this.returnTime;
            if (this.returnTime < 0) {
                this.returnTime = 0;
            }
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantReturnTime(this.returnTime, this.merchant.m_20148_()));
            this.setButtons();
        }));
        removeButton.f_93623_ = this.returnTime > 0;
    }

    private ExtendedButton createTravelStartButton() {
        ExtendedButton extendedButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 19, this.topPos + 32, 40, 20, Translatable.TEXT_BUTTON_TRAVEL_START, button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantTravel(this.merchant.m_20148_(), true, false));
            this.setButtons();
        }));
        extendedButton.m_257544_(Tooltip.m_257550_((Component)Translatable.TOOLTIP_TRAVEL_START));
        return extendedButton;
    }

    private ExtendedButton createTravelStopButton() {
        ExtendedButton extendedButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 62, this.topPos + 32, 40, 20, Translatable.TEXT_BUTTON_TRAVEL_STOP, button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantTravel(this.merchant.m_20148_(), false, false));
            this.setButtons();
        }));
        extendedButton.m_257544_(Tooltip.m_257550_((Component)Translatable.TOOLTIP_TRAVEL_STOP));
        return extendedButton;
    }

    private ExtendedButton createTravelReturnButton() {
        ExtendedButton extendedButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 105, this.topPos + 32, 40, 20, Translatable.TEXT_BUTTON_TRAVEL_RETURN, button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantTravel(this.merchant.m_20148_(), true, true));
            this.setButtons();
        }));
        extendedButton.m_257544_(Tooltip.m_257550_((Component)Translatable.TOOLTIP_TRAVEL_RETURN));
        return extendedButton;
    }

    private ExtendedButton createTravelInfoButton(int x, int y) {
        ExtendedButton extendedButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(x, y, 20, 20, (Component)Component.m_237113_((String)"i"), press -> {
            this.setButtons();
            this.player.m_213846_(Translatable.TEXT_TRAVEL_INFO);
            this.m_7379_();
        }));
        extendedButton.m_257544_(Tooltip.m_257550_((Component)Translatable.TOOLTIP_TRAVEL_INFO));
        return extendedButton;
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        int waypointsPerPage = 10;
        this.returnTime = this.merchant.getReturningTime();
        int currentReturningTime = this.merchant.getCurrentReturningTime();
        guiGraphics.m_280056_(this.f_96547_, "Days:", 20, 9, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, currentReturningTime + " / " + this.merchant.getReturningTime(), 110, 9, 0x404040, false);
        int currentWayPoint = waypoints.size() == 0 ? 0 : this.merchant.getCurrentWayPointIndex() + 1;
        guiGraphics.m_280056_(this.f_96547_, "Waypoints:", 20, 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, currentWayPoint + " / " + waypoints.size(), 110, 20, 0x404040, false);
        int startIndex = (this.page - 1) * waypointsPerPage;
        int endIndex = Math.min(startIndex + waypointsPerPage, waypoints.size());
        if (!waypoints.isEmpty()) {
            for (int i = startIndex; i < endIndex; ++i) {
                BlockPos pos = waypoints.get(i);
                int x = pos.m_123341_();
                int y = pos.m_123342_();
                int z = pos.m_123343_();
                String coordinates = String.format("%d:  (%d,  %d,  %d)", i + 1, x, y, z);
                if (!waypointItems.isEmpty() && waypointItems.get(i) != null) {
                    this.renderItemAt(guiGraphics, waypointItems.get(i), 15, 58 + (i - startIndex) * 17);
                } else {
                    BlockPos pos1 = waypoints.get(i);
                    ItemStack itemStack = this.merchant.getItemStackToRender(pos1);
                    this.renderItemAt(guiGraphics, itemStack, 15, 58 + (i - startIndex) * 17);
                }
                guiGraphics.m_280056_(this.f_96547_, coordinates, 35, 60 + (i - startIndex) * 17, 0x404040, false);
            }
            if (waypoints.size() > waypointsPerPage) {
                guiGraphics.m_280056_(this.f_96547_, "Page: " + this.page, 90, 230, 0x404040, false);
            }
        }
    }

    private void renderItemAt(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        if (itemStack != null) {
            guiGraphics.m_280203_(itemStack, x, y);
        }
    }

    public ExtendedButton createPageBackButton() {
        return (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 15, this.topPos + 230, 12, 12, (Component)Component.m_237113_((String)"<"), button -> {
            if (this.page > 1) {
                --this.page;
            }
            this.setButtons();
        }));
    }

    public Button createPageForwardButton() {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 184, this.topPos + 230, 12, 12, (Component)Component.m_237113_((String)">"), button -> {
            ++this.page;
            this.setButtons();
        }));
    }

    private Button createAddWaypointButton(int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x, y, 20, 20, (Component)Component.m_237113_((String)"+"), button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantAddWayPoint(this.merchant.m_20148_()));
            this.setButtons();
        }));
    }

    private Button createRemoveWaypointButton(int x, int y) {
        return (Button)this.m_142416_((GuiEventListener)new ExtendedButton(x, y, 20, 20, (Component)Component.m_237113_((String)"-"), button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMerchantRemoveWayPoint(this.merchant.m_20148_()));
            this.setButtons();
        }));
    }
}

