/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.talhanation.workers.entities.MerchantEntity;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;

public class MerchantResetCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literalBuilder = (LiteralArgumentBuilder)Commands.m_82127_((String)"workers").requires(source -> source.m_6761_(2));
        literalBuilder.then(Commands.m_82127_((String)"merchants").then(Commands.m_82127_((String)"resetAllCreativeTrades").executes(commandSource -> {
            List<MerchantEntity> merchants = MerchantResetCommand.getListOfLoadedMerchants(((CommandSourceStack)commandSource.getSource()).m_81372_());
            for (MerchantEntity merchant : merchants) {
                MerchantResetCommand.merchantResetTrades(merchant);
            }
            CommandSourceStack source = (CommandSourceStack)commandSource.getSource();
            if (!merchants.isEmpty()) {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully reset trades for " + merchants.size() + " merchants.")), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)"No merchants found to reset trades.").m_130940_(ChatFormatting.RED));
            return 0;
        })));
        dispatcher.register(literalBuilder);
    }

    private static List<MerchantEntity> getListOfLoadedMerchants(ServerLevel level) {
        return StreamSupport.stream(level.m_142646_().m_142273_().spliterator(), false).filter(entity -> {
            MerchantEntity merchant;
            return entity instanceof MerchantEntity && (merchant = (MerchantEntity)entity).isCreative();
        }).map(MerchantEntity.class::cast).collect(Collectors.toList());
    }

    private static void merchantResetTrades(MerchantEntity merchant) {
        for (int i = 0; i < MerchantEntity.TRADE_SLOT.length; ++i) {
            merchant.setCurrentTrades(i, 0);
        }
    }
}

