/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WorkersModConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec CONFIG;
    public static ForgeConfigSpec.IntValue VERSION;
    public static final int NEW_VERSION = 7;
    public static ForgeConfigSpec.BooleanValue WorkerChunkLoading;
    public static ForgeConfigSpec.BooleanValue PlayVillagerAmbientSound;
    public static ForgeConfigSpec.BooleanValue WorkersLookLikeVillagers;
    public static ForgeConfigSpec.IntValue MinerCost;
    public static ForgeConfigSpec.IntValue LumberjackCost;
    public static ForgeConfigSpec.IntValue FishermanCost;
    public static ForgeConfigSpec.IntValue FarmerCost;
    public static ForgeConfigSpec.IntValue CattleFarmerCost;
    public static ForgeConfigSpec.IntValue ChickenFarmerCost;
    public static ForgeConfigSpec.IntValue MerchantCost;
    public static ForgeConfigSpec.IntValue ShepherdCost;
    public static ForgeConfigSpec.IntValue SwineherdCost;
    public static ForgeConfigSpec.ConfigValue<String> WorkersCurrency;
    public static ForgeConfigSpec.BooleanValue CommandScreenToggle;
    public static ForgeConfigSpec.BooleanValue MonsterAttackWorkers;
    public static ForgeConfigSpec.BooleanValue PillagerAttackWorkers;
    public static ForgeConfigSpec.BooleanValue OwnerReceiveInfo;
    public static ForgeConfigSpec.BooleanValue WorkersTablesPOIReleasing;
    public static ForgeConfigSpec.BooleanValue ProfessionBlocksDrop;
    public static ForgeConfigSpec.BooleanValue WorkersPayment;
    public static ForgeConfigSpec.IntValue WorkersPaymentInterval;
    public static ForgeConfigSpec.IntValue WorkersPaymentAmount;
    public static ForgeConfigSpec.EnumValue<AbstractWorkerEntity.NoPaymentAction> WorkersNoPaymentAction;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
        if ((Integer)VERSION.get() != 7) {
            configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
            spec.setConfig((CommentedConfig)configData);
            VERSION.set((Object)7);
            configData.save();
        }
    }

    static {
        VERSION = BUILDER.comment("\n##Version, do not change!##").defineInRange("Version", 0, 0, Integer.MAX_VALUE);
        BUILDER.comment("Workers Config Client Side:").push("WorkersClientSide");
        PlayVillagerAmbientSound = BUILDER.comment("\n----Should Workers Make Villager Huh? sound?----\n\t(takes effect after restart)\n\tdefault: true").define("PlayVillagerAmbientSound", true);
        WorkersLookLikeVillagers = BUILDER.comment("\n----Should Workers look like Villagers?----\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("WorkersLookLikeVillagers", true);
        CommandScreenToggle = BUILDER.comment("\n----CommandScreenToggle----\n\t(takes effect after restart)\n\t\nShould the key to open the command screen be toggled instead of held?\"\"\ndefault: false").worldRestart().define("CommandScreenToggle", false);
        BUILDER.pop();
        BUILDER.comment("Workers Config:").push("Workers");
        OwnerReceiveInfo = BUILDER.comment("\nShould Owners receive info's about the worker through text?\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("OwnerReceiveInfo", true);
        WorkerChunkLoading = BUILDER.comment("\n----WorkerChunkLoading----\n\t(takes effect after restart)\n\t\nShould workers load the chunk they are in?\"\"\ndefault: true").worldRestart().define("WorkerChunkLoading", true);
        WorkersPayment = BUILDER.comment("\nRecruitsPayment\n\t(takes effect after restart)\n\t\nShould workers need to be payed in intervals?\ndefault: false").worldRestart().define("WorkersPayment", false);
        WorkersPaymentInterval = BUILDER.comment("\nRecruitsPaymentInterval\n\t(takes effect after restart)\n\t\nThe interval in minutes workers need to be payed?\ndefault: 15").worldRestart().defineInRange("WorkersPaymentInterval", 15, 1, 1453);
        WorkersPaymentAmount = BUILDER.comment("\nRecruitsPaymentAmount\n\t(takes effect after restart)\n\t\nThe amount of currency workers need to be payed?\ndefault: 1").worldRestart().defineInRange("WorkersPaymentAmount", 1, 1, 1453);
        WorkersNoPaymentAction = BUILDER.comment("\nRecruitsNoPaymentAction\n\t(takes effect after restart)\n\t\nThe action the workers will do when they don't get payed.\ndefault: DISBAND").worldRestart().defineEnum("WorkersNoPaymentAction", (Enum)AbstractWorkerEntity.NoPaymentAction.DISBAND);
        WorkersCurrency = BUILDER.comment("\n----Currency----\n\t(takes effect after restart)\n\tThe Item defined here, will be used to hire workers. For example: [\"minecraft:diamond\"]\tdefault: [\"minecraft:emerald\"]").worldRestart().define("WorkersCurrency", (Object)"minecraft:emerald");
        MinerCost = BUILDER.comment("\nThe amount of currency required to hire a miner.\n\t(takes effect after restart)\n\tdefault: 20").worldRestart().defineInRange("MinerCost", 20, 0, 999);
        LumberjackCost = BUILDER.comment("\nThe amount of currency required to hire a lumberjack.\n\t(takes effect after restart)\n\tdefault: 14").worldRestart().defineInRange("LumberjackCost", 14, 0, 999);
        FishermanCost = BUILDER.comment("\nThe amount of currency required to hire a fisherman.\n\t(takes effect after restart)\n\tdefault: 25").worldRestart().defineInRange("FishermanCost", 25, 0, 999);
        FarmerCost = BUILDER.comment("\nThe amount of currency required to hire a farmer.\n\t(takes effect after restart)\n\tdefault: 11").worldRestart().defineInRange("FarmerCost", 11, 0, 999);
        ChickenFarmerCost = BUILDER.comment("\nThe amount of currency required to hire a chicken farmer.\n\t(takes effect after restart)\n\tdefault: 15").worldRestart().defineInRange("ChickenFarmerCost", 15, 0, 999);
        CattleFarmerCost = BUILDER.comment("\nThe amount of currency required to hire a cattle farmer.\n\t(takes effect after restart)\n\tdefault: 15").worldRestart().defineInRange("CattleFarmerCost", 18, 0, 999);
        ShepherdCost = BUILDER.comment("\nThe amount of currency required to hire a shepherd.\n\t(takes effect after restart)\n\tdefault: 10").worldRestart().defineInRange("ShepherdCost", 16, 0, 999);
        SwineherdCost = BUILDER.comment("\nThe amount of currency required to hire a swineherd.\n\t(takes effect after restart)\n\tdefault: 10").worldRestart().defineInRange("SwineherdCost", 19, 0, 999);
        MerchantCost = BUILDER.comment("\nThe amount of currency required to hire a merchant.\n\t(takes effect after restart)\n\tdefault: 12").worldRestart().defineInRange("MerchantCost", 12, 0, 999);
        MonsterAttackWorkers = BUILDER.comment("\nShould Hostile Mobs attack Workers?\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("MonsterAttackWorkers", true);
        PillagerAttackWorkers = BUILDER.comment("\nShould Pillagers attack Workers?\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("PillagerAttackWorkers", true);
        BUILDER.pop();
        BUILDER.comment("Recruit Village Config:").push("Villages");
        WorkersTablesPOIReleasing = BUILDER.comment("\n----Should Villager Workers that were created with Tables release the POI for other Villagers?----\n----True -> allows multiple villagers to become a worker with one table.----\n----False -> only one villager can become a recruit with one table.----\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("WorkersTablesPOIReleasing", false);
        ProfessionBlocksDrop = BUILDER.comment("\n----Should the profession tables drop when breaking?----\n\t(takes effect after restart)\n\tdefault: true").worldRestart().define("ProfessionBlocksDrop", true);
        CONFIG = BUILDER.build();
    }
}

