/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.init;

import com.google.common.collect.ImmutableSet;
import com.talhanation.workers.init.ModPois;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModProfessions {
    private static final Logger logger = LogManager.getLogger((String)"workers");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"workers");
    public static final RegistryObject<VillagerProfession> MINER = ModProfessions.makeProfession("miner", ModPois.POI_MINER);
    public static final RegistryObject<VillagerProfession> LUMBERJACK = ModProfessions.makeProfession("lumberjack", ModPois.POI_LUMBERJACK);
    public static final RegistryObject<VillagerProfession> FARMER = ModProfessions.makeProfession("farmer", ModPois.POI_FARMER);
    public static final RegistryObject<VillagerProfession> MERCHANT = ModProfessions.makeProfession("merchant", ModPois.POI_MERCHANT);
    public static final RegistryObject<VillagerProfession> SHEPHERD = ModProfessions.makeProfession("shepherd", ModPois.POI_SHEPHERD);
    public static final RegistryObject<VillagerProfession> FISHER = ModProfessions.makeProfession("fisherman", ModPois.POI_FISHER);
    public static final RegistryObject<VillagerProfession> CATTLE_FARMER = ModProfessions.makeProfession("cattle_farmer", ModPois.POI_CATTLE_FARMER);
    public static final RegistryObject<VillagerProfession> CHICKEN_FARMER = ModProfessions.makeProfession("chicken_farmer", ModPois.POI_CHICKEN_FARMER);
    public static final RegistryObject<VillagerProfession> SWINEHERD = ModProfessions.makeProfession("swineherd", ModPois.POI_SWINEHERD);

    private static final RegistryObject<VillagerProfession> makeProfession(String name, RegistryObject<PoiType> pointOfInterest) {
        logger.info("Registering profession for {} with POI {}", (Object)name, pointOfInterest);
        return PROFESSIONS.register(name, () -> new VillagerProfession(name, poi -> poi.get() == pointOfInterest.get(), poi -> poi.get() == pointOfInterest.get(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12504_));
    }
}

