/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.inventory;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.init.ModMenuTypes;
import de.maxhenkel.workers.corelib.inventory.ContainerBase;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MerchantOwnerContainer
extends ContainerBase {
    private final Container workerTradeInventory;
    private final MerchantEntity merchant;

    public MerchantOwnerContainer(int id, MerchantEntity merchant, Inventory playerInventory) {
        super((MenuType)ModMenuTypes.MERCHANT_OWNER_CONTAINER_TYPE.get(), id, (Container)playerInventory, (Container)merchant.getInventory());
        this.merchant = merchant;
        this.workerTradeInventory = merchant.getTradeInventory();
        this.addWorkerTradeSlots();
        this.addWorkerPriceSlots();
        this.addPlayerInventorySlots();
    }

    @Override
    public int getInvOffset() {
        return 56;
    }

    public void addWorkerPriceSlots() {
        for (int k = 0; k < MerchantEntity.PRICE_SLOT.length; ++k) {
            this.m_38897_(new Slot(this.workerTradeInventory, MerchantEntity.PRICE_SLOT[k], 26, 16 + k * 18){

                public boolean m_5857_(@NotNull ItemStack itemStack) {
                    MerchantOwnerContainer.this.workerTradeInventory.m_6836_(this.getSlotIndex(), itemStack.m_41777_());
                    return false;
                }

                public boolean m_8010_(@NotNull Player player) {
                    ItemStack slotStack = MerchantOwnerContainer.this.workerTradeInventory.m_8020_(this.getSlotIndex());
                    if (slotStack.m_150930_(this.getCarried().m_41720_())) {
                        int current;
                        int count = this.getCarried().m_41613_();
                        int amount = count + (current = slotStack.m_41613_());
                        if (amount > slotStack.m_41741_()) {
                            amount = slotStack.m_41741_();
                        }
                        slotStack.m_41764_(amount);
                    } else {
                        MerchantOwnerContainer.this.workerTradeInventory.m_6836_(this.getSlotIndex(), ItemStack.f_41583_);
                    }
                    return false;
                }

                public ItemStack getCarried() {
                    return MerchantOwnerContainer.this.m_142621_();
                }
            });
        }
    }

    public void addWorkerTradeSlots() {
        for (int k = 0; k < MerchantEntity.TRADE_SLOT.length; ++k) {
            this.m_38897_(new Slot(this.workerTradeInventory, MerchantEntity.TRADE_SLOT[k], 80, 16 + k * 18){

                public boolean m_5857_(@NotNull ItemStack itemStack) {
                    MerchantOwnerContainer.this.workerTradeInventory.m_6836_(this.getSlotIndex(), itemStack.m_41777_());
                    return false;
                }

                public boolean m_8010_(@NotNull Player player) {
                    ItemStack slotStack = MerchantOwnerContainer.this.workerTradeInventory.m_8020_(this.getSlotIndex());
                    if (slotStack.m_150930_(this.getCarried().m_41720_())) {
                        int current;
                        int count = this.getCarried().m_41613_();
                        int amount = count + (current = slotStack.m_41613_());
                        if (amount > slotStack.m_41741_()) {
                            amount = slotStack.m_41741_();
                        }
                        slotStack.m_41764_(amount);
                    } else {
                        MerchantOwnerContainer.this.workerTradeInventory.m_6836_(this.getSlotIndex(), ItemStack.f_41583_);
                    }
                    return false;
                }

                public ItemStack getCarried() {
                    return MerchantOwnerContainer.this.m_142621_();
                }
            });
        }
    }

    @Override
    public ItemStack m_7648_(Player playerIn, int index) {
        return ItemStack.f_41583_;
    }

    public AbstractWorkerEntity getWorker() {
        return this.merchant;
    }

    @Override
    public boolean m_6875_(Player playerIn) {
        return this.workerTradeInventory.m_6542_(playerIn) && this.merchant.m_6084_() && this.merchant.m_20270_((Entity)playerIn) < 8.0f;
    }

    @Override
    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
    }

    public void m_38946_() {
        super.m_38946_();
        this.merchant.upgradeTool();
        this.merchant.upgradeArmor();
    }
}

