/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Iterator;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedScaffoldingBlock
extends ScaffoldingBlock
implements EntityBlock,
IReinforcedBlock {
    public ReinforcedScaffoldingBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.m_5880_(x$0, x$1, x$2, x$3), state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.f_50616_;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        EntityCollisionContext ectx;
        if (ctx instanceof EntityCollisionContext && this.ownsScaffolding(level, pos, (ectx = (EntityCollisionContext)ctx).m_193113_())) {
            return super.m_5940_(state, level, pos, ctx);
        }
        return (Boolean)state.m_61143_((Property)f_56014_) != false ? f_56016_ : f_56015_;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        EntityCollisionContext ectx;
        if (ctx instanceof EntityCollisionContext && this.ownsScaffolding(level, pos, (ectx = (EntityCollisionContext)ctx).m_193113_())) {
            return super.m_5939_(state, level, pos, ctx);
        }
        return Shapes.m_83040_();
    }

    public boolean isScaffolding(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return this.ownsScaffolding((BlockGetter)level, pos, (Entity)entity);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return super.isLadder(state, level, pos, entity) && this.ownsScaffolding((BlockGetter)level, pos, (Entity)entity);
    }

    public boolean ownsScaffolding(BlockGetter level, BlockPos pos, Entity entity) {
        IOwnable ownable;
        BlockEntity blockEntity;
        return !(entity instanceof LivingEntity) || (blockEntity = level.m_7702_(pos)) instanceof IOwnable && (ownable = (IOwnable)blockEntity).isOwnedBy(entity);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        int distance = ReinforcedScaffoldingBlock.m_56024_((BlockGetter)level, pos);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_56013_, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)f_56012_, (Comparable)Integer.valueOf(distance))).m_61124_((Property)f_56014_, (Comparable)Boolean.valueOf(this.m_56027_((BlockGetter)level, pos, distance)));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int distance = ReinforcedScaffoldingBlock.m_56024_((BlockGetter)level, pos);
        BlockState newState = (BlockState)((BlockState)state.m_61124_((Property)f_56012_, (Comparable)Integer.valueOf(distance))).m_61124_((Property)f_56014_, (Comparable)Boolean.valueOf(this.m_56027_((BlockGetter)level, pos, distance)));
        if ((Integer)newState.m_61143_((Property)f_56012_) == 7) {
            if ((Integer)state.m_61143_((Property)f_56012_) == 7) {
                CompoundTag data = level.m_7702_(pos).m_187482_();
                FallingBlockEntity entity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)newState);
                entity.f_31944_ = data;
            } else {
                level.m_46961_(pos, true);
            }
        } else if (state != newState) {
            level.m_7731_(pos, newState, 3);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return ReinforcedScaffoldingBlock.m_56024_((BlockGetter)level, pos) < 7;
    }

    public static int m_56024_(BlockGetter level, BlockPos pos) {
        Direction direction;
        BlockState offsetState;
        BlockPos.MutableBlockPos mutable = pos.m_122032_().m_122173_(Direction.DOWN);
        BlockState mutableState = level.m_8055_((BlockPos)mutable);
        int distance = 7;
        if (mutableState.m_60713_((Block)SCContent.REINFORCED_SCAFFOLDING.get())) {
            distance = (Integer)mutableState.m_61143_((Property)f_56012_);
        } else if (mutableState.m_60783_(level, (BlockPos)mutable, Direction.UP)) {
            return 0;
        }
        Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
        while (iterator.hasNext() && (!(offsetState = level.m_8055_((BlockPos)mutable.m_122159_((Vec3i)pos, direction = (Direction)iterator.next()))).m_60713_((Block)SCContent.REINFORCED_SCAFFOLDING.get()) || (distance = Math.min(distance, (Integer)offsetState.m_61143_((Property)f_56012_) + 1)) != 1)) {
        }
        return distance;
    }
}

