/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.Arrays;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class CheckPasscode {
    private BlockPos pos;
    private int entityId;
    private String passcode;

    public CheckPasscode() {
    }

    public CheckPasscode(BlockPos pos, String passcode) {
        this.pos = pos;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public CheckPasscode(int entityId, String passcode) {
        this.entityId = entityId;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public CheckPasscode(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.m_130135_();
        } else {
            this.entityId = buf.m_130242_();
        }
        this.passcode = buf.m_130136_(0x1FFFFFFF);
    }

    public void encode(FriendlyByteBuf buf) {
        boolean hasPos = this.pos != null;
        buf.writeBoolean(hasPos);
        if (hasPos) {
            buf.m_130064_(this.pos);
        } else {
            buf.m_130130_(this.entityId);
        }
        buf.m_130070_(this.passcode);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        IPasscodeProtected passcodeProtected = this.getPasscodeProtected(player.m_9236_());
        if (passcodeProtected != null) {
            if (PasscodeUtils.isOnCooldown((Player)player)) {
                PlayerUtils.sendMessageToPlayer((Player)player, Component.m_237113_((String)"SecurityCraft"), Component.m_237115_((String)"messages.securitycraft:passcodeProtected.onCooldown"), ChatFormatting.RED);
                if (((Boolean)ConfigHandler.SERVER.passcodeSpamLogWarningEnabled.get()).booleanValue()) {
                    SecurityCraft.LOGGER.warn(this.formatForPasscodeProtected((String)ConfigHandler.SERVER.passcodeSpamLogWarning.get(), (Player)player, passcodeProtected));
                }
                return;
            }
            if (passcodeProtected.isOnCooldown()) {
                return;
            }
            PasscodeUtils.setOnCooldown((Player)player);
            PasscodeUtils.hashPasscode(this.passcode, passcodeProtected.getSalt(), p -> {
                if (Arrays.equals(passcodeProtected.getPasscode(), p)) {
                    player.m_6915_();
                    passcodeProtected.activate((Player)player);
                } else {
                    passcodeProtected.onIncorrectPasscodeEntered((Player)player, this.passcode);
                }
            });
        }
    }

    private IPasscodeProtected getPasscodeProtected(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (blockEntity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)blockEntity;
                return pp;
            }
        } else {
            Entity entity = level.m_6815_(this.entityId);
            if (entity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)entity;
                return pp;
            }
        }
        return null;
    }

    private String formatForPasscodeProtected(String logMessage, Player player, IPasscodeProtected passcodeProtected) {
        Level level = player.m_9236_();
        BlockPos pos = BlockPos.f_121853_;
        String name = "undefined";
        if (passcodeProtected instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)passcodeProtected;
            pos = be.m_58899_();
            name = level.m_8055_(pos).m_60734_().m_49954_().getString();
        } else if (passcodeProtected instanceof Entity) {
            Entity entity = (Entity)passcodeProtected;
            pos = entity.m_20183_();
            name = entity.m_6095_().m_20676_().getString();
        }
        return String.format(logMessage, player.m_36316_().getName(), name, GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos));
    }
}

