/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.parts;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.properties.synched.IHaveSynchedProperties;
import com.endertech.minecraft.forge.properties.synched.SynchedDoubleProperty;
import com.endertech.minecraft.forge.properties.synched.SynchedProperties;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adhooks.client.ControlBindings;
import com.endertech.minecraft.mods.adhooks.items.LauncherItem;
import com.endertech.minecraft.mods.adhooks.network.MakeShotMsg;
import com.endertech.minecraft.mods.adhooks.network.WatchedBoolMsg;
import com.endertech.minecraft.mods.adhooks.parts.HookShot;
import com.endertech.minecraft.mods.adhooks.properties.HookType;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;

public class Launcher
implements IHaveSynchedProperties {
    public static final String TAG_HOOKSHOT_ID = "hookShotId";
    public static final int DAMAGE_ON_SHOT = 1;
    public final HookType hookType;
    public final String name;
    public final Lazy<LauncherItem> item;
    protected final SynchedDoubleProperty reelingSpeed;
    protected final SynchedDoubleProperty launchVelocity;
    protected final SynchedDoubleProperty jumpBoostStrength;
    protected final SynchedDoubleProperty tarzanJumpStrength;
    protected final SynchedDoubleProperty shooterWeightFactor;
    protected final Map<InteractionHand, Cooldowns> cooldownsByHand = new EnumMap<InteractionHand, Cooldowns>(InteractionHand.class);
    protected final Map<InteractionHand, WatchedStates> watchedStatesByHand = new EnumMap<InteractionHand, WatchedStates>(InteractionHand.class);
    private final SynchedProperties synchedProperties = new SynchedProperties("Launcher");

    public Launcher(HookType hookType, Properties<?> props) {
        this.hookType = hookType;
        this.name = props.name;
        this.item = Lazy.of(() -> new LauncherItem(hookType, props));
        this.launchVelocity = this.synchedProperty("launchVelocity", props.launchVelocity, FloatBounds.between((Float)Float.valueOf(0.1f), (Float)Float.valueOf(10.0f)), "Launch velocity of the hook");
        this.reelingSpeed = this.synchedProperty("reelingSpeed", props.reelingSpeed, FloatBounds.between((Float)Float.valueOf(0.1f), (Float)Float.valueOf(4.0f)), "Controls how fast the launcher reels in the rope");
        this.jumpBoostStrength = this.synchedProperty("jumpBoostStrength", props.jumpBoostStrength, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(3.0f)), "Controls how high you will be thrown when performing Jump Boost or Tarzan Jump");
        this.tarzanJumpStrength = this.synchedProperty("tarzanJumpStrength", props.tarzanJumpStrength, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(3.0f)), "Controls how far you will be thrown when performing Tarzan Jump");
        this.shooterWeightFactor = this.synchedProperty("shooterWeightFactor", props.shooterWeightFactor, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1000.0f)), "Allows to adjust your weight advantage/disadvantage over the hooked entity");
    }

    public float getLaunchVelocity() {
        return ((Double)this.launchVelocity.getValue()).floatValue();
    }

    public float getReelingSpeed() {
        return ((Double)this.reelingSpeed.getValue()).floatValue();
    }

    public float getJumpBoostStrength() {
        return ((Double)this.jumpBoostStrength.getValue()).floatValue();
    }

    public float getTarzanJumpStrength() {
        return ((Double)this.tarzanJumpStrength.getValue()).floatValue();
    }

    public float getShooterWeightFactor() {
        return ((Double)this.shooterWeightFactor.getValue()).floatValue();
    }

    public SynchedProperties getSynchedProperties() {
        return this.synchedProperties;
    }

    public void makeShot(ItemStack launcher, LivingEntity shooter) {
        Level level = shooter.m_9236_();
        if (level instanceof ServerLevel) {
            HookShot hookShot;
            ServerLevel level2 = (ServerLevel)level;
            if (this.hookType != HookType.PROTOTYPE && DamageableItem.notBroken((ItemStack)launcher) && level2.m_7967_((Entity)(hookShot = new HookShot((Level)level2, shooter, this.hookType)))) {
                hookShot.launch(shooter.m_20154_(), this.getLaunchVelocity(), 1.0f);
                Launcher.attachToHookShot(launcher, hookShot);
                DamageableItem.damageItem((int)1, (ItemStack)launcher, (boolean)false, (LivingEntity)shooter, null);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processPressedKeysBy(LocalPlayer player, InteractionHand activeHand) {
        if (!GameKeys.affectPlayer()) {
            return;
        }
        Cooldowns cooldowns = this.cooldownsByHand.computeIfAbsent(activeHand, Cooldowns::new);
        WatchedStates states = this.watchedStatesByHand.computeIfAbsent(activeHand, WatchedStates::new);
        ItemStack activeItem = player.m_21120_(activeHand);
        boolean kdJumping = ControlBindings.isKeyDownFor(activeHand, HookShot.SynchedBools.JUMPING);
        boolean kdLaunching = ControlBindings.isKeyDownFor(activeHand, HookShot.SynchedBools.LAUNCHING);
        boolean kdPulling = ControlBindings.isKeyDownFor(activeHand, HookShot.SynchedBools.PULLING);
        boolean kdLoosening = ControlBindings.isKeyDownFor(activeHand, HookShot.SynchedBools.LOOSENING);
        boolean kdUnhooking = ControlBindings.isKeyDownFor(activeHand, HookShot.SynchedBools.UNHOOKING);
        boolean shotAttached = Launcher.isShotAttached(activeItem);
        Function<HookShot.SynchedBools, Boolean> kdDoubleJumping = key -> {
            if (kdJumping) {
                if (!cooldowns.maxxed((HookShot.SynchedBools)((Object)key)) && !cooldowns.expired((HookShot.SynchedBools)((Object)key))) {
                    cooldowns.reset((HookShot.SynchedBools)((Object)key));
                    cooldowns.reset(HookShot.SynchedBools.LAUNCHING);
                    return true;
                }
                cooldowns.set((HookShot.SynchedBools)((Object)key), 4);
            } else {
                cooldowns.tick((HookShot.SynchedBools)((Object)key));
            }
            return false;
        };
        if (shotAttached) {
            cooldowns.tickIfTrueElseZero(HookShot.SynchedBools.UNHOOKING, b -> kdUnhooking);
        } else {
            cooldowns.tickIfTrueElseZero(HookShot.SynchedBools.LAUNCHING, b -> kdLaunching);
        }
        if (kdLaunching && !shotAttached) {
            HitResult result = Minecraft.m_91087_().f_91077_;
            Optional<KeyMapping> launching = ControlBindings.getKeyBindingFor(activeHand, HookShot.SynchedBools.LAUNCHING);
            if ((result == null || result.m_6662_() == HitResult.Type.MISS || !ControlBindings.conflictsWithAttackOrUse(launching)) && cooldowns.expired(HookShot.SynchedBools.LAUNCHING)) {
                new MakeShotMsg(activeHand).sendToServer();
                cooldowns.reset(HookShot.SynchedBools.UNHOOKING);
                states.bools.clear();
            }
        }
        states.updateAndSync(HookShot.SynchedBools.PULLING, pulling -> kdPulling && !kdLoosening);
        states.updateAndSync(HookShot.SynchedBools.LOOSENING, loosening -> ControlBindings.areSameForBothHands(loosening) ? kdLoosening && kdPulling : kdLoosening && !kdPulling);
        states.updateAndSync(HookShot.SynchedBools.UNHOOKING, unhooking -> shotAttached && cooldowns.expired((HookShot.SynchedBools)((Object)unhooking)) && (ControlBindings.areSameForBothHands(unhooking) ? kdUnhooking && kdPulling : kdUnhooking));
        states.updateAndSync(HookShot.SynchedBools.JUMPING, jumping -> kdJumping);
        states.updateAndSync(HookShot.SynchedBools.DOUBLE_JUMPING, kdDoubleJumping);
        if (states.get(HookShot.SynchedBools.UNHOOKING)) {
            cooldowns.reset(HookShot.SynchedBools.LAUNCHING);
        }
    }

    public static boolean isShotAttached(ItemStack launcher) {
        return Launcher.stackHasLauncher(launcher) && launcher.m_41782_() && launcher.m_41783_().m_128441_(TAG_HOOKSHOT_ID);
    }

    public static boolean isAttachedToHookShot(ItemStack launcher, HookShot hookShot) {
        return Launcher.isShotAttached(launcher) && Launcher.getAttachedHookShotId(launcher) == hookShot.m_19879_();
    }

    public static int getAttachedHookShotId(ItemStack launcher) {
        if (launcher.m_41782_()) {
            return launcher.m_41783_().m_128451_(TAG_HOOKSHOT_ID);
        }
        return 0;
    }

    public static boolean stackHasLauncher(ItemStack stack) {
        return stack.m_41720_() instanceof LauncherItem;
    }

    public static Optional<HookShot> findAttachedHookShot(ItemStack launcher, Level world) {
        Entity entity;
        if (Launcher.isShotAttached(launcher) && (entity = world.m_6815_(Launcher.getAttachedHookShotId(launcher))) instanceof HookShot) {
            return Optional.of((HookShot)entity);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> findAttachedLauncher(Inventory inventory, HookShot hookShot) {
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            ItemStack stack = inventory.m_8020_(slot);
            if (!Launcher.isAttachedToHookShot(stack, hookShot)) continue;
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public static void attachToHookShot(ItemStack launcher, HookShot hookShot) {
        if (Launcher.stackHasLauncher(launcher) && hookShot != null) {
            CompoundTag tag = launcher.m_41784_();
            tag.m_128405_(TAG_HOOKSHOT_ID, hookShot.m_19879_());
        }
    }

    public static void unattach(ItemStack launcher) {
        if (Launcher.stackHasLauncher(launcher) && launcher.m_41782_()) {
            launcher.m_41783_().m_128473_(TAG_HOOKSHOT_ID);
        }
    }

    public static class Properties<T extends Properties<T>>
    extends DamageableItem.Properties<T> {
        public float reelingSpeed;
        public float launchVelocity;
        public float jumpBoostStrength = 1.0f;
        public float tarzanJumpStrength = 1.0f;
        public float shooterWeightFactor = 1.0f;

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
            this.repairMaterial = UnitId.from((String)"string");
        }

        public T reelingSpeed(float value) {
            this.reelingSpeed = value;
            return (T)((Object)((Properties)this.self));
        }

        public T launchVelocity(float value) {
            this.launchVelocity = value;
            return (T)((Object)((Properties)this.self));
        }

        public T jumpBoost(float strength) {
            this.jumpBoostStrength = strength;
            return (T)((Object)((Properties)this.self));
        }

        public T tarzanJump(float strength) {
            this.tarzanJumpStrength = strength;
            return (T)((Object)((Properties)this.self));
        }

        public T shooterWeightFactor(float value) {
            this.shooterWeightFactor = value;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static class Cooldowns {
        static final int TICKS_MAX_DEFAULT = 10;
        protected final InteractionHand hand;
        protected final Map<HookShot.SynchedBools, Integer> ticksRemain;
        protected final Map<HookShot.SynchedBools, Integer> ticksMax;

        public Cooldowns(InteractionHand hand) {
            this.hand = hand;
            this.ticksRemain = new EnumMap<HookShot.SynchedBools, Integer>(HookShot.SynchedBools.class);
            this.ticksMax = new EnumMap<HookShot.SynchedBools, Integer>(HookShot.SynchedBools.class);
        }

        public void tick(HookShot.SynchedBools key) {
            this.ticksRemain.computeIfPresent(key, (k, ticks) -> ticks > 0 ? ticks - 1 : 0);
        }

        public boolean expired(HookShot.SynchedBools key) {
            return this.ticksRemain(key) == 0;
        }

        public boolean maxxed(HookShot.SynchedBools key) {
            return this.ticksRemain(key) == this.ticksMax(key);
        }

        public int ticksRemain(HookShot.SynchedBools key) {
            return Optional.ofNullable(this.ticksRemain.get((Object)key)).orElse(0);
        }

        public int ticksMax(HookShot.SynchedBools key) {
            return Optional.ofNullable(this.ticksMax.get((Object)key)).orElse(10);
        }

        public void set(HookShot.SynchedBools key, int ticks) {
            if (ticks != 0 && ticks != 10) {
                this.ticksMax.put(key, ticks);
            }
            this.ticksRemain.put(key, Math.max(ticks, 0));
        }

        public void reset(HookShot.SynchedBools key) {
            this.set(key, this.ticksMax(key));
        }

        public void zero(HookShot.SynchedBools key) {
            this.set(key, 0);
        }

        public void tickIfTrueElseZero(HookShot.SynchedBools key, Predicate<HookShot.SynchedBools> predicate) {
            if (predicate.test(key)) {
                this.tick(key);
            } else {
                this.zero(key);
            }
        }
    }

    public static class WatchedStates {
        protected final InteractionHand hand;
        protected final Map<HookShot.SynchedBools, Boolean> bools;

        public WatchedStates(InteractionHand hand) {
            this.hand = hand;
            this.bools = new EnumMap<HookShot.SynchedBools, Boolean>(HookShot.SynchedBools.class);
        }

        public boolean get(HookShot.SynchedBools action) {
            return this.bools.computeIfAbsent(action, a -> false);
        }

        public void updateAndSync(HookShot.SynchedBools action, Function<HookShot.SynchedBools, Boolean> newValueFunc) {
            boolean newValue;
            boolean oldValue = this.get(action);
            if (oldValue != (newValue = newValueFunc.apply(action).booleanValue())) {
                this.bools.put(action, newValue);
                WatchedBoolMsg.sendToServer(this.hand, action, newValue);
            }
        }
    }
}

