/*
 * Decompiled with CFR 0.152.
 */
package ballistix.client.particle;

import ballistix.registers.BallistixParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class ParticleOptionsMissileSmoke
extends ParticleType<ParticleOptionsMissileSmoke>
implements ParticleOptions {
    public static final Codec<ParticleOptionsMissileSmoke> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(instance0 -> Float.valueOf(instance0.r)), (App)Codec.FLOAT.fieldOf("g").forGetter(instance0 -> Float.valueOf(instance0.g)), (App)Codec.FLOAT.fieldOf("b").forGetter(instance0 -> Float.valueOf(instance0.b)), (App)Codec.FLOAT.fieldOf("scale").forGetter(instance0 -> Float.valueOf(instance0.scale)), (App)Codec.INT.fieldOf("lifetime").forGetter(instance0 -> instance0.lifetime), (App)Codec.BOOL.fieldOf("physics").forGetter(instance0 -> instance0.hasPhysics)).apply((Applicative)instance, (r, g, b, scale, lifetime, physics) -> new ParticleOptionsMissileSmoke().setParameters(r.floatValue(), g.floatValue(), b.floatValue(), scale.floatValue(), (int)lifetime, (boolean)physics)));
    public static final ParticleOptions.Deserializer<ParticleOptionsMissileSmoke> DESERIALIZER = new ParticleOptions.Deserializer<ParticleOptionsMissileSmoke>(){

        public ParticleOptionsMissileSmoke fromCommand(ParticleType<ParticleOptionsMissileSmoke> type, StringReader reader) throws CommandSyntaxException {
            ParticleOptionsMissileSmoke particle = new ParticleOptionsMissileSmoke();
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            boolean physics = reader.readBoolean();
            return particle.setParameters(r, g, b, scale, lifetime, physics);
        }

        public ParticleOptionsMissileSmoke fromNetwork(ParticleType<ParticleOptionsMissileSmoke> type, FriendlyByteBuf buffer) {
            return new ParticleOptionsMissileSmoke().setParameters(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.readBoolean());
        }
    };
    public float r;
    public float g;
    public float b;
    public float scale;
    public int lifetime = 1;
    public boolean hasPhysics;

    public ParticleOptionsMissileSmoke() {
        super(false, DESERIALIZER);
    }

    public ParticleOptionsMissileSmoke setParameters(float r, float g, float b, float scale, int lifetime, boolean physics) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.scale = scale;
        this.lifetime = lifetime;
        this.hasPhysics = physics;
        return this;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)BallistixParticles.PARTICLE_MISSILE_SMOKE.get();
    }

    public Codec<ParticleOptionsMissileSmoke> m_7652_() {
        return CODEC;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.r);
        buffer.writeFloat(this.g);
        buffer.writeFloat(this.b);
        buffer.writeFloat(this.scale);
        buffer.writeInt(this.lifetime);
        buffer.writeBoolean(this.hasPhysics);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()).toString() + ", r: " + this.r + ", g: " + this.g + ", b: " + this.b + ", scale: " + this.scale + ", lifetime: " + this.lifetime + ", physics: " + this.hasPhysics;
    }
}

