/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier1;

import ballistix.api.blast.IHasCustomRender;
import ballistix.client.particle.ParticleOptionsShockwave;
import ballistix.common.blast.util.Blast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.settings.BallistixConstants;
import ballistix.compatibility.griefdefender.GriefDefenderHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlastRepulsive
extends Blast
implements IHasCustomRender {
    public BlastRepulsive(Level world, BlockPos position) {
        super(world, position);
    }

    @Override
    public boolean doExplode(int callCount) {
        super.doExplode(callCount);
        this.hasStarted = true;
        if (!this.world.f_46443_) {
            this.world.m_254849_(null, (double)this.position.m_123341_() + 0.5, (double)this.position.m_123342_() + 0.5, (double)this.position.m_123343_() + 0.5, (float)BallistixConstants.EXPLOSIVE_REPULSIVE_SIZE, Level.ExplosionInteraction.BLOCK);
        } else {
            this.produceParticles();
        }
        float x = this.position.m_123341_();
        float y = this.position.m_123342_();
        float z = this.position.m_123343_();
        float size = 7.0f;
        float doubleSize = size * 2.0f;
        int x0 = Mth.m_14107_((double)((double)x - (double)doubleSize - 1.0));
        int x1 = Mth.m_14107_((double)((double)x + (double)doubleSize + 1.0));
        int y0 = Mth.m_14107_((double)((double)y - (double)doubleSize - 1.0));
        int y1 = Mth.m_14107_((double)((double)y + (double)doubleSize + 1.0));
        int z0 = Mth.m_14107_((double)((double)z - (double)doubleSize - 1.0));
        int z1 = Mth.m_14107_((double)((double)z + (double)doubleSize + 1.0));
        List entities = this.world.m_45933_(null, new AABB((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
        block3: for (Entity entity : entities) {
            switch (this.griefPreventionMethod) {
                case GRIEF_DEFENDER: {
                    if (GriefDefenderHandler.shouldEntityBeHarmed(entity)) break;
                    continue block3;
                }
            }
            double deltaX = entity.m_20185_() - (double)x;
            double deltaY = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - (double)y;
            double deltaZ = entity.m_20189_() - (double)z;
            double deltaDistance = Mth.m_14116_((float)((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)));
            if (deltaDistance == 0.0) continue;
            double d11 = BallistixConstants.EXPLOSIVE_ATTRACTIVE_REPULSIVE_PUSH_STRENGTH;
            entity.m_20256_(entity.m_20184_().m_82520_((deltaX /= deltaDistance) * d11, (deltaY /= deltaDistance) * d11, (deltaZ /= deltaDistance) * d11));
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer serverplayerentity = (ServerPlayer)entity;
            serverplayerentity.f_8906_.m_9829_((Packet)new ClientboundExplodePacket((double)x, (double)y, (double)z, size, new ArrayList(), new Vec3(deltaX * d11, deltaY * d11, deltaZ * d11)));
        }
        return true;
    }

    @Override
    public SubtypeBlast getBlastType() {
        return SubtypeBlast.repulsive;
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void produceParticles() {
        float x = (float)this.position.m_123341_() + 0.5f;
        float y = (float)this.position.m_123342_() + 0.5f;
        float z = (float)this.position.m_123343_() + 0.5f;
        float size = 7.0f;
        float f2 = size * 2.0f;
        int x0 = Mth.m_14107_((double)((double)(x - f2) - 1.0));
        int x1 = Mth.m_14107_((double)((double)(x + f2) + 1.0));
        int y0 = Mth.m_14107_((double)((double)(y - f2) - 1.0));
        int y1 = Mth.m_14107_((double)((double)(y + f2) + 1.0));
        int z0 = Mth.m_14107_((double)((double)(z - f2) - 1.0));
        int z1 = Mth.m_14107_((double)((double)(z + f2) + 1.0));
        for (int dx = x0; dx < x1; ++dx) {
            for (int dy = y0; dy < y1; ++dy) {
                for (int dz = z0; dz < z1; ++dz) {
                    if (!((x - (float)dx) * (x - (float)dx) + (y - (float)dy) * (y - (float)dy) + (z - (float)dz) * (z - (float)dz) <= (2.0f * size + 1.0f) * (2.0f * size + 1.0f)) || !((double)this.world.f_46441_.m_188501_() < 0.025)) continue;
                    ParticleOptionsShockwave particle = new ParticleOptionsShockwave().setParameters(1.0f, 1.0f, 1.0f, 1.0f, 0.3f, 15, false, 1.0);
                    Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)particle, (double)x, (double)y, (double)z, (double)(-(x - (float)dx)) / 15.0, (double)(-(y - (float)dy)) / 15.0, (double)(-(z - (float)dz)) / 15.0);
                }
            }
        }
    }
}

