/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.block.subtype;

import ballistix.Ballistix;
import ballistix.api.blast.IBlast;
import ballistix.common.blast.tier1.BlastAnvil;
import ballistix.common.blast.tier1.BlastAttractive;
import ballistix.common.blast.tier1.BlastChemical;
import ballistix.common.blast.tier1.BlastCondensive;
import ballistix.common.blast.tier1.BlastDebilitation;
import ballistix.common.blast.tier1.BlastIncendiary;
import ballistix.common.blast.tier1.BlastInfestive;
import ballistix.common.blast.tier1.BlastRepulsive;
import ballistix.common.blast.tier1.BlastShrapnel;
import ballistix.common.blast.tier2.BlastBreaching;
import ballistix.common.blast.tier2.BlastContagious;
import ballistix.common.blast.tier2.BlastFragmentation;
import ballistix.common.blast.tier2.BlastSonic;
import ballistix.common.blast.tier2.BlastThermobaric;
import ballistix.common.blast.tier3.BlastAntigravity;
import ballistix.common.blast.tier3.BlastAntimatter;
import ballistix.common.blast.tier3.BlastDarkmatter;
import ballistix.common.blast.tier3.BlastEMP;
import ballistix.common.blast.tier3.BlastEnder;
import ballistix.common.blast.tier3.BlastEndothermic;
import ballistix.common.blast.tier3.BlastExothermic;
import ballistix.common.blast.tier3.BlastHypersonic;
import ballistix.common.blast.tier3.BlastLargeAntimatter;
import ballistix.common.blast.tier3.BlastNuclear;
import ballistix.common.blast.tier3.BlastRejuvination;
import ballistix.common.blast.tierother.BlastLandmine;
import ballistix.common.blast.tierother.BlastObsidian;
import ballistix.common.blast.util.Blast;
import ballistix.common.block.BlockExplosive;
import ballistix.registers.BallistixBlocks;
import ballistix.registers.BallistixItems;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import voltaic.api.ISubtype;
import voltaic.common.block.voxelshapes.VoxelShapeProvider;

public enum SubtypeBlast implements ISubtype,
IBlast
{
    obsidian(BlastObsidian::new, 120, 1),
    condensive(BlastCondensive::new, 30, 1),
    attractive(BlastAttractive::new, 30, 1),
    repulsive(BlastRepulsive::new, 30, 1),
    incendiary(BlastIncendiary::new, 80, 1),
    shrapnel(BlastShrapnel::new, 40, 1),
    chemical(BlastChemical::new, 100, 1),
    anvil(BlastAnvil::new, 100, 1),
    infestive(BlastInfestive::new, 40, 1),
    debilitation(BlastDebilitation::new, 80, 1),
    fragmentation(BlastFragmentation::new, 100, 2),
    contagious(BlastContagious::new, 100, 2),
    breaching(BlastBreaching::new, 5, 2),
    thermobaric(BlastThermobaric::new, 100, 2),
    sonic(BlastSonic::new, 80, 2),
    antigravity(BlastAntigravity::new, 100, 3),
    emp(BlastEMP::new, 80, 3),
    nuclear(BlastNuclear::new, 200, 3),
    endothermic(BlastEndothermic::new, 80, 3),
    exothermic(BlastExothermic::new, 80, 3),
    ender(BlastEnder::new, 100, 3),
    hypersonic(BlastHypersonic::new, 150, 3),
    rejuvination(BlastRejuvination::new, 400, 3),
    antimatter(BlastAntimatter::new, 400, 3),
    largeantimatter(BlastLargeAntimatter::new, 600, 3),
    darkmatter(BlastDarkmatter::new, 400, 3),
    landmine(BlastLandmine::new, 5, VoxelShapeProvider.createOmni((VoxelShape)Shapes.m_166049_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.1875, (double)1.0)), -1);

    private final Blast.BlastFactory<?> factory;
    private final int fuse;
    private final VoxelShapeProvider shape;
    private final int tier;

    private SubtypeBlast(Blast.BlastFactory<?> factory, int fuse, VoxelShapeProvider shape, int tier) {
        this.factory = factory;
        this.fuse = fuse;
        this.shape = shape;
        this.tier = tier;
    }

    private SubtypeBlast(Blast.BlastFactory<?> factory, int fuse, int tier) {
        this(factory, fuse, VoxelShapeProvider.DEFAULT, tier);
    }

    public String forgeTag() {
        return this.tag();
    }

    public boolean isItem() {
        return true;
    }

    public String tag() {
        return this.name();
    }

    @Override
    public int fuse() {
        return this.fuse;
    }

    @Override
    public Blast createBlast(Level world, BlockPos pos) {
        return this.factory.create(world, pos);
    }

    @Override
    public int tier() {
        return this.tier;
    }

    @Override
    public VoxelShapeProvider getShape() {
        return this.shape;
    }

    @Override
    public ResourceLocation id() {
        return Ballistix.rl(this.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public Supplier<Item> getExplosiveItem() {
        return () -> (Item)BallistixItems.ITEMS_EXPLOSIVE.getValue((Object)this);
    }

    @Override
    public Supplier<Block> getExplosiveBlock() {
        return () -> (Block)BallistixBlocks.BLOCKS_EXPLOSIVE.getValue((Object)this);
    }

    @Override
    public void onEntityInside(BlockState state, Level level, BlockPos pos, Entity ent) {
        if (this == landmine) {
            BlockExplosive.explode(level, pos, this);
            level.m_7471_(pos, false);
        }
    }
}

