/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.entity;

import ballistix.api.blast.IBlast;
import ballistix.api.blast.IHasCustomRender;
import ballistix.common.blast.util.Blast;
import ballistix.registers.BallistixEntities;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.NetworkHooks;

public class EntityBlast
extends Entity {
    private static final EntityDataAccessor<Integer> CALLCOUNT = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> SHOULDSTARTCUSTOMRENDER = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TICKCOUNT = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOULD_PERSIST = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> PERSISTANCE_TICKS = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICKS_PERSISTED = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_MATURED = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TICKS_AT_MATURITY = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MOVEMENT_TICKS = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICKS_MOVING = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.m_135353_(EntityBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Blast blast;
    public ResourceLocation blastId;
    public int callcount = 0;
    public boolean shouldRenderCustom = false;
    public int ticksWhenCustomRender;
    private boolean detonated = false;
    private boolean shouldPersist = false;
    private int persistanceTicks = 0;
    private int ticksPersisted = 0;
    private int movementTicks = 0;
    private int ticksMoving = 0;
    public boolean hasMatured = false;
    public int ticksAtMaturity = 0;
    private boolean moving = false;

    public EntityBlast(EntityType<? extends EntityBlast> type, Level worldIn) {
        super(type, worldIn);
        this.f_19850_ = true;
    }

    public EntityBlast(Level worldIn) {
        this((EntityType<? extends EntityBlast>)((EntityType)BallistixEntities.ENTITY_BLAST.get()), worldIn);
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public void setPersistant(int tickCount, int movementTicks) {
        this.persistanceTicks = tickCount;
        this.movementTicks = movementTicks;
    }

    public void setBlastType(IBlast explosive) {
        this.blastId = explosive.id();
        this.blast = this.getBlastType().createBlast(this.m_9236_(), this.m_20183_());
    }

    @Nullable
    public IBlast getBlastType() {
        return this.blastId == null ? null : Blast.BLAST_MAP.get(this.blastId);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CALLCOUNT, (Object)0);
        this.f_19804_.m_135372_(TYPE, (Object)"");
        this.f_19804_.m_135372_(SHOULDSTARTCUSTOMRENDER, (Object)false);
        this.f_19804_.m_135372_(TICKCOUNT, (Object)0);
        this.f_19804_.m_135372_(SHOULD_PERSIST, (Object)false);
        this.f_19804_.m_135372_(PERSISTANCE_TICKS, (Object)0);
        this.f_19804_.m_135372_(HAS_MATURED, (Object)false);
        this.f_19804_.m_135372_(TICKS_AT_MATURITY, (Object)0);
        this.f_19804_.m_135372_(TICKS_PERSISTED, (Object)0);
        this.f_19804_.m_135372_(MOVEMENT_TICKS, (Object)0);
        this.f_19804_.m_135372_(MOVING, (Object)false);
        this.f_19804_.m_135372_(TICKS_MOVING, (Object)0);
    }

    public void m_8119_() {
        ++this.f_19797_;
        if (this.detonated) {
            if (!this.m_9236_().f_46443_ && this.f_19797_ > 20) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (!this.m_9236_().f_46443_) {
            IHasCustomRender has;
            if (this.blastId != null) {
                this.f_19804_.m_135381_(TYPE, (Object)this.blastId.toString());
            }
            this.f_19804_.m_135381_(CALLCOUNT, (Object)this.callcount);
            Blast blast = this.blast;
            this.f_19804_.m_135381_(SHOULDSTARTCUSTOMRENDER, (Object)(blast instanceof IHasCustomRender && (has = (IHasCustomRender)((Object)blast)).shouldRender() ? 1 : 0));
            this.f_19804_.m_135381_(TICKCOUNT, (Object)this.f_19797_);
            this.f_19804_.m_135381_(SHOULD_PERSIST, (Object)this.shouldPersist);
            this.f_19804_.m_135381_(PERSISTANCE_TICKS, (Object)this.persistanceTicks);
            this.f_19804_.m_135381_(TICKS_PERSISTED, (Object)this.ticksPersisted);
            this.f_19804_.m_135381_(HAS_MATURED, (Object)this.hasMatured);
            this.f_19804_.m_135381_(TICKS_AT_MATURITY, (Object)this.ticksAtMaturity);
            this.f_19804_.m_135381_(MOVEMENT_TICKS, (Object)this.movementTicks);
            this.f_19804_.m_135381_(MOVING, (Object)this.moving);
            this.f_19804_.m_135381_(TICKS_MOVING, (Object)this.ticksMoving);
        } else {
            String str = (String)this.f_19804_.m_135370_(TYPE);
            if (!str.isEmpty()) {
                this.blastId = new ResourceLocation(str);
            }
            this.callcount = (Integer)this.f_19804_.m_135370_(CALLCOUNT);
            if (!this.shouldRenderCustom && ((Boolean)this.f_19804_.m_135370_(SHOULDSTARTCUSTOMRENDER)).booleanValue()) {
                this.ticksWhenCustomRender = this.f_19797_;
            }
            this.shouldRenderCustom = (Boolean)this.f_19804_.m_135370_(SHOULDSTARTCUSTOMRENDER);
            if (this.blast != null) {
                this.blast.shouldRenderCustomClient = this.shouldRenderCustom;
            }
            this.f_19797_ = (Integer)this.f_19804_.m_135370_(TICKCOUNT);
            this.shouldPersist = (Boolean)this.f_19804_.m_135370_(SHOULD_PERSIST);
            this.persistanceTicks = (Integer)this.f_19804_.m_135370_(PERSISTANCE_TICKS);
            this.ticksPersisted = (Integer)this.f_19804_.m_135370_(TICKS_PERSISTED);
            this.hasMatured = (Boolean)this.f_19804_.m_135370_(HAS_MATURED);
            this.ticksAtMaturity = (Integer)this.f_19804_.m_135370_(TICKS_AT_MATURITY);
            this.movementTicks = (Integer)this.f_19804_.m_135370_(MOVEMENT_TICKS);
            this.moving = (Boolean)this.f_19804_.m_135370_(MOVING);
            this.ticksMoving = (Integer)this.f_19804_.m_135370_(TICKS_MOVING);
        }
        if (this.blastId == null) {
            return;
        }
        if (this.blast == null) {
            this.blast = this.getBlastType().createBlast(this.m_9236_(), this.m_20183_());
            if (this.shouldPersist && this.hasMatured) {
                this.blast.isRepeating = true;
            }
        }
        if (this.blast != null) {
            if (this.shouldPersist) {
                if (this.persistanceTicks == -1 || this.ticksPersisted > this.persistanceTicks) {
                    this.detonated = true;
                    return;
                }
                if (this.hasMatured) {
                    if (this.moving) {
                        this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
                        ++this.ticksMoving;
                        if (this.ticksMoving >= this.movementTicks) {
                            this.moving = false;
                            this.ticksMoving = 0;
                            this.callcount = 0;
                            this.blast = this.getBlastType().createBlast(this.m_9236_(), this.m_20183_());
                            this.blast.isRepeating = true;
                        }
                    } else {
                        if (this.callcount == 0) {
                            this.blast.preExplode();
                        } else if (this.blast.explode(this.callcount)) {
                            this.blast.postExplode();
                            if (!this.m_9236_().f_46443_) {
                                float perc;
                                float relativeHeight;
                                double dX = this.m_9236_().f_46441_.m_188500_() * (double)(this.m_9236_().f_46441_.m_188499_() ? 1 : -1);
                                double dY = this.m_9236_().f_46441_.m_188500_() * (double)(this.m_9236_().f_46441_.m_188499_() ? 1 : -1);
                                double dZ = this.m_9236_().f_46441_.m_188500_() * (double)(this.m_9236_().f_46441_.m_188499_() ? 1 : -1);
                                int deltaHeight = this.m_9236_().m_151558_() - this.m_9236_().m_141937_();
                                float fifths = (float)deltaHeight / 5.0f;
                                if (dY < 0.0 && this.m_20186_() <= (double)((float)this.m_9236_().m_141937_() + fifths)) {
                                    relativeHeight = (float)(this.m_20186_() - (double)this.m_9236_().m_141937_());
                                    perc = 1.0f - relativeHeight / fifths;
                                    if (this.m_9236_().f_46441_.m_188501_() <= perc) {
                                        dY = Math.abs(dY);
                                    }
                                }
                                if (dY > 0.0 && this.m_20186_() >= (double)((float)this.m_9236_().m_141937_() + fifths * 3.0f)) {
                                    relativeHeight = (float)(this.m_20186_() - (double)this.m_9236_().m_141937_());
                                    perc = relativeHeight / (fifths * 5.0f);
                                    if (this.m_9236_().f_46441_.m_188501_() <= perc) {
                                        dY = -dY;
                                    }
                                }
                                this.m_20334_(dX, dY, dZ);
                            }
                            this.moving = true;
                            ++this.persistanceTicks;
                        }
                        ++this.callcount;
                    }
                } else {
                    if (this.callcount == 0) {
                        this.blast.preExplode();
                    } else if (this.blast.explode(this.callcount)) {
                        this.blast.postExplode();
                        this.hasMatured = true;
                        this.ticksAtMaturity = this.f_19797_;
                        this.ticksPersisted = 0;
                        this.ticksMoving = 0;
                        this.callcount = 0;
                        ChunkPos pos = this.m_9236_().m_46865_(this.m_20183_()).m_7697_();
                        ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.m_9236_()), (String)"ballistix", (BlockPos)this.m_20183_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)false, (boolean)true);
                    }
                    ++this.callcount;
                }
            } else {
                if (this.callcount == 0) {
                    this.blast.preExplode();
                } else if (this.blast.explode(this.callcount)) {
                    this.detonated = true;
                    this.blast.postExplode();
                }
                ++this.callcount;
            }
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().m_5776_() && !this.hasMatured) {
            ChunkPos pos = this.m_9236_().m_46865_(this.m_20183_()).m_7697_();
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.m_9236_()), (String)"ballistix", (BlockPos)this.m_20183_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)true, (boolean)true);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && reason == Entity.RemovalReason.DISCARDED && !this.hasMatured) {
            ChunkPos pos = this.m_9236_().m_46865_(this.m_20183_()).m_7697_();
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.m_9236_()), (String)"ballistix", (BlockPos)this.m_20183_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)false, (boolean)true);
        }
        super.m_142687_(reason);
    }

    protected void m_7380_(CompoundTag compound) {
        ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.blastId).result().ifPresent(tag -> compound.m_128365_("type", tag));
        compound.m_128405_("callcount", this.callcount);
        compound.m_128405_("persistanceticks", this.persistanceTicks);
        compound.m_128405_("tickspersisted", this.ticksPersisted);
        compound.m_128405_("ticksatmaturity", this.ticksAtMaturity);
        compound.m_128405_("movementticks", this.movementTicks);
        compound.m_128405_("ticksmoving", this.ticksMoving);
        compound.m_128379_("moivng", this.moving);
        compound.m_128379_("shouldpersist", this.shouldPersist);
        compound.m_128379_("hasmatured", this.hasMatured);
    }

    protected void m_7378_(CompoundTag compound) {
        ResourceLocation.f_135803_.decode((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("type")).result().ifPresent(pair -> {
            this.blastId = (ResourceLocation)pair.getFirst();
        });
        this.callcount = compound.m_128451_("callcount");
        if (this.blastId != null) {
            this.setBlastType(this.getBlastType());
        }
        this.persistanceTicks = compound.m_128451_("persistanceticks");
        this.ticksPersisted = compound.m_128451_("tickspersisted");
        this.ticksAtMaturity = compound.m_128451_("ticksatmaturity");
        this.shouldPersist = compound.m_128471_("shouldpersist");
        this.hasMatured = compound.m_128471_("hasmatured");
        this.movementTicks = compound.m_128451_("movementticks");
        this.moving = compound.m_128471_("moving");
        this.ticksMoving = compound.m_128451_("ticksmoving");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Blast getBlast() {
        return this.blast;
    }
}

