/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile.radar;

import ballistix.api.missile.MissileManager;
import ballistix.api.missile.virtual.VirtualMissile;
import ballistix.common.inventory.container.ContainerFireControlRadar;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.TileESMTower;
import ballistix.registers.BallistixSounds;
import ballistix.registers.BallistixTiles;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;
import voltaic.api.sound.SoundAPI;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.ListProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileFireControlRadar
extends GenericTile {
    public static final long PULSE_TIME_TICKS = 25L;
    public static final Vec3 OUT_OF_REACH = new Vec3(0.0, -1000.0, 0.0);
    public final SingleProperty<Vec3> trackingPos = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.VEC3, "trackingpos", (Object)OUT_OF_REACH));
    public final SingleProperty<Boolean> usingWhitelist = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "usingwhitelist", (Object)false));
    public final ListProperty<Integer> whitelistedFrequencies = (ListProperty)this.property((AbstractProperty)new ListProperty(PropertyTypes.INTEGER_LIST, "whitelistedfreqs", new ArrayList()));
    public final SingleProperty<Integer> missileType = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "trackingtype", (Object)-1));
    public final SingleProperty<Boolean> usingRedstone = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "usingredstone", (Object)false));
    public final SingleProperty<Boolean> redstone = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstone", (Object)false));
    public final SingleProperty<Boolean> running = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "running", (Object)false));
    public final Vec3 searchPos;
    private final AABB searchArea = new AABB(this.m_58899_()).m_82400_((double)BallistixConstants.FIRE_CONTROL_RADAR_RANGE);
    @Nullable
    public VirtualMissile tracking;
    public double clientRotation;
    public double clientRotationSpeed;

    public TileFireControlRadar(BlockPos pos, BlockState state) {
        super((BlockEntityType)BallistixTiles.TILE_FIRECONTROLRADAR.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(120.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules(BallistixConstants.FIRE_CONTROL_RADAR_USAGE * 20.0));
        this.addComponent((IComponent)new ComponentContainerProvider("firecontrolradar", (GenericTile)this).createMenu((id, player) -> new ContainerFireControlRadar((int)id, (Inventory)player, (Container)new SimpleContainer(0), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
        this.searchPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        this.running.setValue((Object)(electro.getJoulesStored() > BallistixConstants.RADAR_USAGE / 20.0 && this.f_58857_.m_45517_(LightLayer.SKY, this.m_58899_()) > 0 && ((Boolean)this.usingRedstone.getValue() == false || (Boolean)this.usingRedstone.getValue() != false && (Boolean)this.redstone.getValue() != false) ? 1 : 0));
        if (!((Boolean)this.running.getValue()).booleanValue()) {
            this.tracking = null;
            TileESMTower.removeFireControlRadar(this);
            return;
        }
        TileESMTower.addFireControlRadar(this);
        electro.joules(electro.getJoulesStored() - BallistixConstants.RADAR_USAGE / 20.0);
        if (this.tracking != null && (this.tracking.hasExploded() || this.tracking.getId() == null || MissileManager.getMissile((ResourceKey<Level>)this.f_58857_.m_46472_(), this.tracking.getId()) == null)) {
            this.tracking = null;
            this.trackingPos.setValue((Object)OUT_OF_REACH);
        }
        VirtualMissile temp = null;
        for (VirtualMissile missile : MissileManager.getMissilesForLevel((ResourceKey<Level>)this.f_58857_.m_46472_())) {
            if (!missile.getBoundingBox().m_82381_(this.searchArea)) continue;
            if (temp == null && (!((Boolean)this.usingWhitelist.getValue()).booleanValue() || ((Boolean)this.usingWhitelist.getValue()).booleanValue() && !((List)this.whitelistedFrequencies.getValue()).contains(missile.payloadData.frequency)) && !missile.hasExploded()) {
                temp = missile;
                continue;
            }
            if (temp == null || !(TileFireControlRadar.getDistanceToMissile(this.searchPos, missile.position) < TileFireControlRadar.getDistanceToMissile(this.searchPos, temp.position)) || ((Boolean)this.usingWhitelist.getValue()).booleanValue() && (!((Boolean)this.usingWhitelist.getValue()).booleanValue() || ((List)this.whitelistedFrequencies.getValue()).contains(missile.payloadData.frequency)) || missile.hasExploded()) continue;
            temp = missile;
        }
        if (this.tracking == null) {
            this.tracking = temp;
        }
        if (this.tracking != null && !this.tracking.hasExploded()) {
            this.trackingPos.setValue((Object)this.tracking.position);
            this.missileType.setValue((Object)this.tracking.payloadData.missileType);
            Vec3 vec3 = new Vec3((double)this.f_58858_.m_123341_(), ((Vec3)this.trackingPos.getValue()).f_82480_, (double)this.f_58858_.m_123343_());
            if (((Vec3)this.trackingPos.getValue()).m_82554_(vec3) > (double)BallistixConstants.FIRE_CONTROL_RADAR_RANGE) {
                this.tracking = null;
                this.trackingPos.setValue((Object)OUT_OF_REACH);
            }
        } else {
            this.trackingPos.setValue((Object)OUT_OF_REACH);
            this.missileType.setValue((Object)-1);
        }
    }

    public void tickClient(ComponentTickable tickable) {
        this.clientRotation += this.clientRotationSpeed;
        this.clientRotationSpeed = Mth.m_14008_((double)(this.clientRotationSpeed + 0.25 * (double)((Boolean)this.running.getValue() != false ? 1 : -1)), (double)0.0, (double)20.0);
        if (tickable.getTicks() % 25L == 0L && ((Boolean)this.running.getValue()).booleanValue()) {
            SoundAPI.playSound((SoundEvent)((SoundEvent)BallistixSounds.SOUND_FIRECONTROLRADAR.get()), (SoundSource)SoundSource.BLOCKS, (float)1.0f, (float)1.0f, (BlockPos)this.f_58858_);
        }
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        super.onNeightborChanged(neighbor, blockStateTrigger);
        this.redstone.setValue((Object)(this.f_58857_.m_277086_(this.m_58899_()) > 0 ? 1 : 0));
    }

    public static double getDistanceToMissile(Vec3 pos, Vec3 missilePos) {
        double deltaX = missilePos.f_82479_ - pos.f_82479_;
        double deltaY = missilePos.f_82480_ - pos.f_82480_;
        double deltaZ = missilePos.f_82481_ - pos.f_82481_;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static double getTimeToIntercept(Vec3 missPos, Vec3 missVect, float missSpeed, float bulletSpeed, Vec3 interceptorPos) {
        double c;
        Vec3 missVector = missVect.m_82490_((double)missSpeed);
        double a = missVector.m_82526_(missVector) - (double)(bulletSpeed * bulletSpeed);
        if (a == 0.0) {
            return -1.0;
        }
        double b = missPos.m_82526_(missVector) * 2.0;
        double root = b * b - 4.0 * a * (c = missPos.m_82526_(missPos));
        if (root < 0.0) {
            return -1.0;
        }
        if (root == 0.0) {
            return -b / (2.0 * a);
        }
        root = Math.sqrt(root);
        double sol1 = (-b - root) / (2.0 * a);
        double sol2 = (-b + root) / (2.0 * a);
        if (sol1 > 0.0 && sol2 > 0.0) {
            return -1.0;
        }
        if (sol1 > 0.0) {
            return -sol2;
        }
        if (sol2 > 0.0) {
            return -sol1;
        }
        return -Math.max(sol1, sol2);
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.f_58857_.f_46443_) {
            TileESMTower.removeFireControlRadar(this);
            ChunkPos pos = this.f_58857_.m_46865_(this.m_58899_()).m_7697_();
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"ballistix", (BlockPos)this.m_58899_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)false, (boolean)true);
        }
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (!this.f_58857_.f_46443_) {
            ChunkPos pos = this.f_58857_.m_46865_(this.m_58899_()).m_7697_();
            ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_58857_), (String)"ballistix", (BlockPos)this.m_58899_(), (int)pos.f_45578_, (int)pos.f_45579_, (boolean)true, (boolean)true);
        }
    }

    public int getComparatorSignal() {
        return ((Vec3)this.trackingPos.getValue()).equals((Object)OUT_OF_REACH) ? 0 : 15;
    }
}

