/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.screen.tile;

import electrodynamics.common.inventory.container.tile.ContainerCreativePowerSource;
import electrodynamics.common.tile.electricitygrid.generators.TileCreativePowerSource;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.MeasurementUnits;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;

public class ScreenCreativePowerSource
extends GenericScreen<ContainerCreativePowerSource> {
    private ScreenComponentEditBox voltage = new ScreenComponentEditBox(80, 27, 49, 16, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(6).setFilter(ScreenComponentEditBox.POSITIVE_INTEGER).setResponder(this::setVoltage);
    private ScreenComponentEditBox power;
    private boolean needsUpdate = true;

    public ScreenCreativePowerSource(ContainerCreativePowerSource container, Inventory inv, Component titleIn) {
        super((GenericContainer)container, inv, titleIn);
        this.addComponent((AbstractScreenComponent)this.voltage);
        this.power = new ScreenComponentEditBox(80, 45, 49, 16, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setFilter(ScreenComponentEditBox.POSITIVE_DECIMAL).setResponder(this::setPower);
        this.addComponent((AbstractScreenComponent)this.power);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(40, 31, 10, Color.TEXT_GRAY, (Component)ElectroTextUtils.gui("creativepowersource.voltage", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(40, 49, 10, Color.TEXT_GRAY, (Component)ElectroTextUtils.gui("creativepowersource.power", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(131, 31, 10, Color.TEXT_GRAY, DisplayUnits.VOLTAGE.getSymbol()));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(131, 49, 10, Color.TEXT_GRAY, (Component)MeasurementUnits.MEGA.getSymbol().m_6881_().m_7220_(DisplayUnits.WATT.getSymbol())));
    }

    private void setVoltage(String val) {
        this.voltage.setFocus(true);
        this.power.setFocus(false);
        this.handleVoltage(val);
    }

    private void handleVoltage(String val) {
        if (val.isEmpty()) {
            return;
        }
        Integer voltage = 0;
        try {
            voltage = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileCreativePowerSource tile = (TileCreativePowerSource)((ContainerCreativePowerSource)this.f_97732_).getSafeHost();
        if (tile == null) {
            return;
        }
        tile.voltage.setValue((Object)voltage);
    }

    private void setPower(String val) {
        this.voltage.setFocus(false);
        this.power.setFocus(true);
        this.handlePower(val);
    }

    private void handlePower(String val) {
        if (val.isEmpty()) {
            return;
        }
        Double power = 0.0;
        try {
            power = Double.parseDouble(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileCreativePowerSource tile = (TileCreativePowerSource)((ContainerCreativePowerSource)this.f_97732_).getSafeHost();
        if (tile == null) {
            return;
        }
        tile.power.setValue((Object)power);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            TileCreativePowerSource source = (TileCreativePowerSource)((ContainerCreativePowerSource)this.f_97732_).getSafeHost();
            if (source != null) {
                this.voltage.setValue("" + source.voltage.getValue());
                this.power.setValue("" + source.power.getValue());
            }
        }
    }
}

