/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.block;

import electrodynamics.common.block.states.ElectrodynamicsBlockStates;
import electrodynamics.common.tile.machines.quarry.TileFrame;
import electrodynamics.registers.ElectrodynamicsBlocks;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockFrame
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape FRAME = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape FRAME_CORNER = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0));
    private final int type;

    public BlockFrame(int type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(3.5f).m_60918_(SoundType.f_56743_).m_60955_().m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ElectrodynamicsBlockStates.QUARRY_FRAME_DECAY, (Comparable)Boolean.FALSE)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.type = type;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (this.type == 0) {
            return FRAME;
        }
        if (this.type == 1) {
            return FRAME_CORNER;
        }
        return super.m_5940_(pState, pLevel, pPos, pContext);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder builder) {
        return Collections.emptyList();
    }

    public boolean m_6724_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)ElectrodynamicsBlockStates.QUARRY_FRAME_DECAY);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ElectrodynamicsBlockStates.QUARRY_FRAME_DECAY});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_46597_(pPos, Blocks.f_50016_.m_49966_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.m_61143_((Property)BlockStateProperties.f_61362_) == Boolean.TRUE) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return state.m_61143_((Property)BlockStateProperties.f_61362_) == Boolean.TRUE ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileFrame(pos, state);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity entity;
        if (newState.m_60795_() && !((Boolean)state.m_61143_((Property)ElectrodynamicsBlockStates.QUARRY_FRAME_DECAY)).booleanValue() && !level.f_46443_ && (entity = level.m_7702_(pos)) != null && entity instanceof TileFrame) {
            TileFrame frame = (TileFrame)entity;
            frame.purposefullyDestroyed();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public static void writeToNbt(CompoundTag tag, String key, BlockState state) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("facing", ((Direction)state.m_61143_((Property)FACING)).ordinal());
        data.m_128379_("waterlogged", ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue());
        data.m_128379_("decay", ((Boolean)state.m_61143_((Property)ElectrodynamicsBlockStates.QUARRY_FRAME_DECAY)).booleanValue());
        tag.m_128365_(key, (Tag)data);
    }

    public static BlockState readFromNbt(CompoundTag tag) {
        BlockState state = ((BlockFrame)((Object)ElectrodynamicsBlocks.BLOCK_FRAME.get())).m_49966_();
        int dir = 0;
        if (tag.m_128425_("facing", 8)) {
            String name;
            dir = switch (name = tag.m_128461_("facing")) {
                case "DOWN" -> 0;
                case "UP" -> 1;
                case "NORTH" -> 2;
                case "SOUTH" -> 3;
                case "WEST" -> 4;
                default -> 5;
            };
        } else {
            dir = tag.m_128451_("facing");
        }
        state.m_61124_((Property)FACING, (Comparable)Direction.values()[dir]);
        state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(tag.m_128471_("waterlogged")));
        state.m_61124_((Property)ElectrodynamicsBlockStates.QUARRY_FRAME_DECAY, (Comparable)Boolean.valueOf(tag.m_128471_("decay")));
        return state;
    }
}

