/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.armor.types;

import electrodynamics.client.ElectrodynamicsClientRegister;
import electrodynamics.client.model.armor.ModelCombatArmor;
import electrodynamics.common.item.gear.armor.types.ItemCompositeArmor;
import electrodynamics.common.item.gear.armor.types.ItemHydraulicBoots;
import electrodynamics.common.item.gear.armor.types.ItemJetpack;
import electrodynamics.common.item.gear.armor.types.ItemNightVisionGoggles;
import electrodynamics.common.item.gear.armor.types.ItemServoLeggings;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsFluids;
import electrodynamics.registers.ElectrodynamicsGases;
import electrodynamics.registers.ElectrodynamicsItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.fluid.RestrictedFluidHandlerItemStack;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasHandlerItemStack;
import voltaic.api.gas.GasStack;
import voltaic.api.item.IItemElectric;
import voltaic.common.item.ItemVoltaic;
import voltaic.common.item.gear.ItemVoltaicArmor;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.registers.VoltaicCapabilities;

public class ItemCombatArmor
extends ItemVoltaicArmor
implements IItemElectric {
    public static final String ARMOR_TEXTURE_LOCATION = "electrodynamics:textures/model/armor/combatarmor.png";
    private final ElectricItemProperties properties;
    public static final float OFFSET = 0.2f;

    public ItemCombatArmor(Item.Properties properties, ArmorItem.Type type, Supplier<CreativeModeTab> creativeTab) {
        super((ArmorMaterial)ItemCompositeArmor.CompositeArmor.COMPOSITE_ARMOR, type, properties, creativeTab);
        switch (type) {
            case HELMET: 
            case LEGGINGS: {
                this.properties = (ElectricItemProperties)properties;
                break;
            }
            default: {
                this.properties = new ElectricItemProperties();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> properties) {
                boolean hasChest;
                ItemStack[] armorPiecesArray = new ItemStack[]{new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_COMBATHELMET.get()), new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_COMBATCHESTPLATE.get()), new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_COMBATLEGGINGS.get()), new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_COMBATBOOTS.get())};
                ArrayList armorPieces = new ArrayList();
                entity.m_6168_().forEach(armorPieces::add);
                boolean isBoth = ((ItemStack)armorPieces.get(0)).m_41720_() == armorPiecesArray[3].m_41720_() && ((ItemStack)armorPieces.get(1)).m_41720_() == armorPiecesArray[2].m_41720_();
                boolean bl = hasChest = ((ItemStack)armorPieces.get(2)).m_41720_() == armorPiecesArray[1].m_41720_();
                ModelCombatArmor model = isBoth ? (hasChest ? new ModelCombatArmor(ElectrodynamicsClientRegister.COMBAT_ARMOR_LAYER_COMB_CHEST.m_171564_(), ItemCombatArmor.this.m_40402_()) : new ModelCombatArmor(ElectrodynamicsClientRegister.COMBAT_ARMOR_LAYER_COMB_NOCHEST.m_171564_(), ItemCombatArmor.this.m_40402_())) : (ItemCombatArmor.this.m_40402_() == EquipmentSlot.FEET ? new ModelCombatArmor(ElectrodynamicsClientRegister.COMBAT_ARMOR_LAYER_BOOTS.m_171564_(), ItemCombatArmor.this.m_40402_()) : (hasChest ? new ModelCombatArmor(ElectrodynamicsClientRegister.COMBAT_ARMOR_LAYER_LEG_CHEST.m_171564_(), ItemCombatArmor.this.m_40402_()) : new ModelCombatArmor(ElectrodynamicsClientRegister.COMBAT_ARMOR_LAYER_LEG_NOCHEST.m_171564_(), ItemCombatArmor.this.m_40402_())));
                model.f_102817_ = properties.f_102817_;
                model.f_102609_ = properties.f_102609_;
                model.f_102610_ = properties.f_102610_;
                return model;
            }
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        ArmorItem armor = (ArmorItem)stack.m_41720_();
        switch (armor.m_40402_()) {
            case CHEST: {
                return new GasHandlerItemStack(stack, 30000, 293, 4).setPredicate(ItemJetpack.getGasValidator());
            }
            case FEET: {
                return new RestrictedFluidHandlerItemStack(stack, 2000).setValidator(ItemHydraulicBoots.getPredicate());
            }
        }
        return super.initCapabilities(stack, nbt);
    }

    public void addCreativeModeItems(CreativeModeTab tab, List<ItemStack> items) {
        switch (this.m_40402_()) {
            case HEAD: 
            case LEGS: {
                ItemStack empty = new ItemStack((ItemLike)this);
                IItemElectric.setEnergyStored((ItemStack)empty, (double)0.0);
                items.add(empty);
                ItemStack charged = new ItemStack((ItemLike)this);
                IItemElectric.setEnergyStored((ItemStack)charged, (double)this.getMaximumCapacity(charged));
                items.add(charged);
                break;
            }
            case CHEST: {
                items.add(new ItemStack((ItemLike)this));
                if (VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM == null) break;
                ItemStack full = new ItemStack((ItemLike)this);
                GasStack gas = new GasStack((Gas)ElectrodynamicsGases.HYDROGEN.get(), 30000, 293, 1);
                full.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).ifPresent(cap -> cap.fill(gas, GasAction.EXECUTE));
                CompoundTag tag = full.m_41784_();
                tag.m_128405_("plates", 2);
                items.add(full);
                break;
            }
            case FEET: {
                items.add(new ItemStack((ItemLike)this));
                if (ForgeCapabilities.FLUID_HANDLER_ITEM == null) break;
                ItemStack full = new ItemStack((ItemLike)this);
                full.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(h -> ((RestrictedFluidHandlerItemStack)h).setFluid(new FluidStack((Fluid)ElectrodynamicsFluids.FLUID_HYDRAULIC.get(), 2000)));
                items.add(full);
                break;
            }
        }
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagin) {
        super.m_7373_(stack, level, tooltip, flagin);
        switch (((ArmorItem)stack.m_41720_()).m_40402_()) {
            case HEAD: {
                tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.info", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)this.getJoulesStored(stack), (IDisplayUnit)DisplayUnits.JOULES), (Component)ChatFormatter.getChatDisplayShort((double)this.getMaximumCapacity(stack), (IDisplayUnit)DisplayUnits.JOULES)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.voltage", ChatFormatter.getChatDisplayShort((double)this.properties.receive.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
                IItemElectric.addBatteryTooltip((ItemStack)stack, (Level)level, tooltip);
                if (stack.m_41782_() && stack.m_41783_().m_128471_("on")) {
                    tooltip.add((Component)ElectroTextUtils.tooltip("nightvisiongoggles.status", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("nightvisiongoggles.on", new Object[0]).m_130940_(ChatFormatting.GREEN)));
                    break;
                }
                tooltip.add((Component)ElectroTextUtils.tooltip("nightvisiongoggles.status", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("nightvisiongoggles.off", new Object[0]).m_130940_(ChatFormatting.RED)));
                break;
            }
            case CHEST: {
                ItemJetpack.staticAppendHoverText(stack, level, tooltip, flagin);
                ItemCompositeArmor.staticAppendHoverText(stack, level, tooltip, flagin);
                break;
            }
            case LEGS: {
                tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.info", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)this.getJoulesStored(stack), (IDisplayUnit)DisplayUnits.JOULES), (Component)ChatFormatter.getChatDisplayShort((double)this.getMaximumCapacity(stack), (IDisplayUnit)DisplayUnits.JOULES)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.voltage", ChatFormatter.getChatDisplayShort((double)this.properties.receive.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
                ItemServoLeggings.staticAppendTooltips(stack, level, tooltip, flagin);
                break;
            }
            case FEET: {
                if (ForgeCapabilities.FLUID_HANDLER_ITEM == null) break;
                stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> tooltip.add((Component)VoltaicTextUtils.ratio((Component)ChatFormatter.formatFluidMilibuckets((double)handler.getFluidInTank(0).getAmount()), (Component)ChatFormatter.formatFluidMilibuckets((double)2000.0)).m_130940_(ChatFormatting.GRAY)));
                break;
            }
        }
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        ItemCombatArmor combat = (ItemCombatArmor)stack.m_41720_();
        switch (combat.m_40402_()) {
            case HEAD: {
                ItemNightVisionGoggles.armorTick(stack, world, player);
                break;
            }
            case CHEST: {
                ItemJetpack.armorTick(stack, world, player, 0.2f, true);
                break;
            }
            case LEGS: {
                ItemServoLeggings.armorTick(stack, world, player);
                break;
            }
        }
    }

    public boolean m_142522_(ItemStack stack) {
        ItemCombatArmor combat = (ItemCombatArmor)stack.m_41720_();
        switch (combat.m_40402_()) {
            case HEAD: 
            case LEGS: {
                return this.getJoulesStored(stack) < this.getMaximumCapacity(stack);
            }
            case CHEST: {
                return ItemJetpack.staticIsBarVisible(stack);
            }
            case FEET: {
                return ItemHydraulicBoots.staticIsBarVisible(stack);
            }
        }
        return false;
    }

    public int m_142158_(ItemStack stack) {
        ItemCombatArmor combat = (ItemCombatArmor)stack.m_41720_();
        switch (combat.m_40402_()) {
            case HEAD: 
            case LEGS: {
                return (int)Math.round(13.0 * this.getJoulesStored(stack) / this.getMaximumCapacity(stack));
            }
            case CHEST: {
                return ItemJetpack.staticGetBarWidth(stack);
            }
            case FEET: {
                return ItemHydraulicBoots.staticGetBarWidth(stack);
            }
        }
        return 0;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return ARMOR_TEXTURE_LOCATION;
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    public ElectricItemProperties getElectricProperties() {
        return this.properties;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ItemJetpack.staticCanElytraFly(stack, entity);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return ItemJetpack.staticElytraFlightTick(stack, entity, flightTicks);
    }

    public Item getDefaultStorageBattery() {
        return switch (this.m_40402_()) {
            case EquipmentSlot.HEAD, EquipmentSlot.LEGS -> (ItemVoltaic)ElectrodynamicsItems.ITEM_BATTERY.get();
            default -> Items.f_41852_;
        };
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (this.m_40402_() == EquipmentSlot.CHEST || this.m_40402_() == EquipmentSlot.FEET) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        if (!IItemElectric.overrideOtherStackedOnMe((ItemStack)stack, (ItemStack)other, (Slot)slot, (ClickAction)action, (Player)player, (SlotAccess)access)) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        return true;
    }
}

