/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.packet.types.server;

import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsSounds;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import voltaic.prefab.utilities.ItemUtils;

public class PacketModeSwitchServer {
    private final UUID playerId;
    private final Mode mode;

    public PacketModeSwitchServer(UUID uuid, Mode mode) {
        this.playerId = uuid;
        this.mode = mode;
    }

    public static void handle(PacketModeSwitchServer message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerLevel serverWorld = ((NetworkEvent.Context)context.get()).getSender().m_284548_();
            if (serverWorld != null) {
                ServerPlayer serverPlayer = (ServerPlayer)serverWorld.m_46003_(message.playerId);
                switch (message.mode) {
                    case JETPACK: {
                        ItemStack chest = serverPlayer.m_6844_(EquipmentSlot.CHEST);
                        if (!ItemUtils.testItems((Item)chest.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_JETPACK.get()}) && !ItemUtils.testItems((Item)chest.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_COMBATCHESTPLATE.get()})) break;
                        CompoundTag tag = chest.m_41784_();
                        int curMode = tag.m_128451_("mode");
                        curMode = curMode < 3 ? ++curMode : 0;
                        tag.m_128405_("mode", curMode);
                        serverPlayer.m_6330_((SoundEvent)ElectrodynamicsSounds.SOUND_JETPACKSWITCHMODE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        break;
                    }
                    case SERVOLEGS: {
                        ItemStack legs = serverPlayer.m_6844_(EquipmentSlot.LEGS);
                        if (!ItemUtils.testItems((Item)legs.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_SERVOLEGGINGS.get()}) && !ItemUtils.testItems((Item)legs.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_COMBATLEGGINGS.get()})) break;
                        CompoundTag tag = legs.m_41784_();
                        int curMode = tag.m_128451_("mode");
                        curMode = curMode < 2 ? ++curMode : 0;
                        tag.m_128405_("mode", curMode);
                        serverPlayer.m_6330_((SoundEvent)ElectrodynamicsSounds.SOUND_HYDRAULICBOOTS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        break;
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketModeSwitchServer message, FriendlyByteBuf buf) {
        buf.m_130077_(message.playerId);
        buf.m_130068_((Enum)message.mode);
    }

    public static PacketModeSwitchServer decode(FriendlyByteBuf buf) {
        return new PacketModeSwitchServer(buf.m_130259_(), (Mode)buf.m_130066_(Mode.class));
    }

    public static enum Mode {
        JETPACK,
        SERVOLEGS;

    }
}

