/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid.generators;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerWindmill;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.electricitygrid.generators.GenericGeneratorTile;
import electrodynamics.prefab.utilities.ElectricityUtils;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import voltaic.api.multiblock.subnodebased.TileMultiSubnode;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentBlock;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentTile;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileWindmill
extends GenericGeneratorTile
implements IMultiblockParentTile,
ITickableSound {
    protected CachedTileOutput output;
    private SingleProperty<Boolean> isGenerating = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isGenerating", (Object)false));
    public SingleProperty<Boolean> directionFlag = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "directionFlag", (Object)false));
    public SingleProperty<Double> generating = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "generating", (Object)0.0));
    private SingleProperty<Double> multiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "multiplier", (Object)1.0));
    private SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));
    public double savedTickRotation;
    public double rotationSpeed;
    private boolean isSoundPlaying = false;

    public TileWindmill(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_WINDMILL.get(), worldPosition, blockState, 2.25, SubtypeItemUpgrade.stator);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickCommon(this::tickCommon).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().upgrades(1)).validUpgrades(ContainerWindmill.VALID_UPGRADES).valid(TileWindmill.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.windmill.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerWindmill((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            this.generating.setValue((Object)0.0);
            return;
        }
        Direction facing = this.getFacing();
        if (tickable.getTicks() % 40L == 0L) {
            this.isGenerating.setValue((Object)this.f_58857_.m_46859_(this.f_58858_.m_121945_(facing).m_121945_(Direction.UP)));
            float height = Math.max(0, this.f_58857_.m_141928_());
            double f = Math.log10(((double)Math.max(0, this.m_58899_().m_123342_()) + (double)height / 10.0) * 10.0 / (double)height);
            this.generating.setValue((Object)(ElectroConstants.WINDMILL_MAX_AMPERAGE * Mth.m_14008_((double)f, (double)0.0, (double)1.0)));
        }
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(Direction.DOWN));
        }
        this.output.update(this.f_58858_.m_121945_(Direction.DOWN));
        if (((Boolean)this.isGenerating.getValue()).booleanValue() && this.output.valid()) {
            ElectricityUtils.receivePower((BlockEntity)this.output.getSafe(), Direction.UP, this.getProduced(), false);
        }
    }

    protected void tickCommon(ComponentTickable tickable) {
        this.savedTickRotation += (double)((Boolean)this.directionFlag.getValue() != false ? 1 : -1) * this.rotationSpeed;
        this.rotationSpeed = Mth.m_14008_((double)(this.rotationSpeed + 0.05 * (double)((Boolean)this.isGenerating.getValue() != false ? 1 : -1)), (double)0.0, (double)1.0);
    }

    protected void tickClient(ComponentTickable tickable) {
        if (this.shouldPlaySound() && !this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_HUM.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_276867_(this.m_58899_()));
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.isGenerating.getValue();
    }

    public IMultiblockParentBlock.SubnodeWrapper getSubNodes() {
        return SubtypeMachine.Subnodes.WINDMILL;
    }

    public void setMultiplier(double val) {
        this.multiplier.setValue((Object)val);
    }

    public double getMultiplier() {
        return (Double)this.multiplier.getValue();
    }

    public TransferPack getProduced() {
        return TransferPack.ampsVoltage((double)((Double)this.generating.getValue() * (Double)this.multiplier.getValue()), (double)((ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic)).getVoltage());
    }

    public int getComparatorSignal() {
        return (Boolean)this.isGenerating.getValue() != false ? 15 : 0;
    }

    public void onSubnodeDestroyed(TileMultiSubnode subnode) {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public int getSubdnodeComparatorSignal(TileMultiSubnode subnode) {
        return this.getComparatorSignal();
    }

    public InteractionResult onSubnodeUse(Player player, InteractionHand hand, BlockHitResult hit, TileMultiSubnode subnode) {
        return this.use(player, hand, hit);
    }

    public Direction getFacingDirection() {
        return this.getFacing();
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82363_(0.0, 1.5, 0.0);
    }
}

