/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines.arcfurnace;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerElectricArcFurnace;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.Voltaic;
import voltaic.client.particle.lavawithphysics.ParticleOptionLavaWithPhysics;
import voltaic.common.item.ItemUpgrade;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileElectricArcFurnace
extends GenericTile
implements ITickableSound {
    protected BlastingRecipe[] cachedRecipe = null;
    private List<BlastingRecipe> cachedRecipes = null;
    private boolean isSoundPlaying = false;
    private final int procCount;

    public TileElectricArcFurnace(BlockPos worldPosition, BlockState blockState) {
        this((BlockEntityType)ElectrodynamicsTiles.TILE_ELECTRICARCFURNACE.get(), 1, worldPosition, blockState);
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.electricarcfurnace.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerElectricArcFurnace((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public TileElectricArcFurnace(BlockEntityType<?> type, int procCount, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.procCount = procCount;
        int inputsPerProc = 1;
        int outputPerProc = 1;
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).voltage(120.0 * Math.pow(2.0, procCount - 1)).maxJoules(ElectroConstants.ELECTRICARCFURNACE_USAGE_PER_TICK * 20.0 * (double)procCount));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(procCount, inputsPerProc, outputPerProc, 0).upgrades(3)).validUpgrades(ContainerElectricArcFurnace.VALID_UPGRADES).valid(TileElectricArcFurnace.machineValidator()).implementMachineInputsAndOutputs());
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this, procCount).canProcess(this::canProcess).process(this::process));
        this.cachedRecipe = new BlastingRecipe[procCount];
    }

    protected boolean canProcess(ComponentProcessor component, int procNumber) {
        boolean canProcess = this.checkConditions(component, procNumber);
        if (BlockEntityUtils.isLit((GenericTile)this) ^ (canProcess || component.isAnyActive()) || component.isActive(procNumber)) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)(canProcess || component.isActive(procNumber) ? 1 : 0));
        }
        return canProcess;
    }

    private boolean checkConditions(ComponentProcessor component, int procNumber) {
        component.setShouldKeepProgress(true, procNumber);
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack input = (ItemStack)inv.getInputsForProcessor(procNumber).get(0);
        if (input.m_41619_()) {
            component.setShouldKeepProgress(false, procNumber);
            component.operatingTicks.setValue((Object)0.0, procNumber);
            component.usage(0.0, procNumber);
            return false;
        }
        this.cachedRecipes = this.f_58857_.m_7465_().m_44013_(RecipeType.f_44109_);
        if (this.cachedRecipes == null) {
            // empty if block
        }
        if (this.cachedRecipe == null) {
            component.setShouldKeepProgress(false, procNumber);
            component.operatingTicks.setValue((Object)0.0, procNumber);
            component.usage(0.0, procNumber);
            return false;
        }
        if (this.cachedRecipe[procNumber] == null) {
            this.cachedRecipe[procNumber] = this.getMatchedRecipe(input);
            if (this.cachedRecipe[procNumber] == null) {
                component.setShouldKeepProgress(false, procNumber);
                component.operatingTicks.setValue((Object)0.0, procNumber);
                component.usage(0.0, procNumber);
                return false;
            }
        }
        if (!this.cachedRecipe[procNumber].m_5818_((Container)new SimpleContainer(new ItemStack[]{input}), this.f_58857_)) {
            this.cachedRecipe[procNumber] = null;
            component.setShouldKeepProgress(false, procNumber);
            component.operatingTicks.setValue((Object)0.0, procNumber);
            component.usage(0.0, procNumber);
            return false;
        }
        component.usage.setValue((Object)ElectroConstants.ELECTRICARCFURNACE_USAGE_PER_TICK, procNumber);
        component.requiredTicks.setValue((Object)ElectroConstants.ELECTRICARCFURNACE_REQUIRED_TICKS, procNumber);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < component.getUsage(procNumber) * (Double)component.operatingSpeed.getValue()) {
            return false;
        }
        ItemStack output = (ItemStack)inv.getOutputContents().get(procNumber);
        ItemStack result = this.cachedRecipe[procNumber].m_8043_(this.f_58857_.m_9598_());
        return (output.m_41619_() || output.m_41720_() == result.m_41720_()) && output.m_41613_() + result.m_41613_() <= output.m_41741_();
    }

    protected void process(ComponentProcessor component, int procNumber) {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack input = (ItemStack)inv.getInputsForProcessor(procNumber).get(0);
        ItemStack output = (ItemStack)inv.getOutputsForProcessor(procNumber).get(0);
        ItemStack result = this.cachedRecipe[procNumber].m_8043_(this.f_58857_.m_9598_());
        int index = (Integer)inv.getOutputSlots().get(procNumber);
        if (!output.m_41619_()) {
            output.m_41764_(output.m_41613_() + result.m_41613_());
            inv.m_6836_(index, output);
        } else {
            inv.m_6836_(index, result.m_41777_());
        }
        input.m_41774_(1);
        inv.m_6836_(((Integer)inv.getInputSlotsForProcessor(procNumber).get(0)).intValue(), input.m_41777_());
        for (ItemStack stack : inv.getUpgradeContents()) {
            if (stack.m_41619_() || ((ItemUpgrade)stack.m_41720_()).subtype != SubtypeItemUpgrade.experience) continue;
            CompoundTag tag = stack.m_41784_();
            tag.m_128347_("xp", tag.m_128459_("xp") + (double)this.cachedRecipe[procNumber].m_43750_());
            break;
        }
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!((ComponentProcessor)this.getComponent(IComponentType.Processor)).isAnyActive()) {
            return;
        }
        double threshhold = 0.5;
        if (this.procCount == 2) {
            threshhold = 0.75;
        } else if (this.procCount == 3) {
            threshhold = 0.9;
        }
        if (this.f_58857_.f_46441_.m_188500_() < threshhold) {
            double xShift;
            Direction direction = this.getFacing();
            double axisShift = 0.5;
            if (this.procCount == 2) {
                axisShift = Voltaic.RANDOM.nextDouble(0.5) + 0.25;
            } else if (this.procCount == 3) {
                axisShift = Voltaic.RANDOM.nextDouble(0.6) + 0.22;
            }
            double yShift = 0.6;
            double d = direction.m_122434_() == Direction.Axis.X ? (double)direction.m_122429_() * ((double)direction.m_122429_() == -0.5 ? 0.0 : 0.5) : (xShift = axisShift);
            double zShift = direction.m_122434_() == Direction.Axis.Z ? (double)direction.m_122431_() * ((double)direction.m_122431_() == -0.5 ? 0.0 : 0.5) : axisShift;
            double xVel = (Math.random() * 2.0 - 1.0) * (double)0.4f;
            double yVel = Math.random() * (double)0.4f;
            double zVel = (Math.random() * 2.0 - 1.0) * (double)0.4f;
            double rand = (Math.random() + Math.random() + 1.0) * (double)0.15f;
            double vectorMag = Math.sqrt(xVel * xVel + yVel * yVel + zVel * zVel);
            xVel = xVel / vectorMag * rand * (double)0.4f;
            yVel = Math.max(0.05, yVel / vectorMag * rand * (double)0.4f + (double)0.1f);
            zVel = zVel / vectorMag * rand * (double)0.4f;
            this.f_58857_.m_7106_((ParticleOptions)new ParticleOptionLavaWithPhysics().setParameters(0.05f, 1, 1.0), (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_() + zShift, xVel, yVel, zVel);
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_(), 0.0, 0.0, 0.0);
        }
        if (!this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_HUM.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isAnyActive();
    }

    private BlastingRecipe getMatchedRecipe(ItemStack stack) {
        for (BlastingRecipe recipe : this.cachedRecipes) {
            if (!recipe.m_5818_((Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_)) continue;
            return recipe;
        }
        return null;
    }

    public int getComparatorSignal() {
        return (int)((double)((ComponentProcessor)this.getComponent(IComponentType.Processor)).getTotalActive() / (double)Math.max(1, ((ComponentProcessor)this.getComponent(IComponentType.Processor)).getProcessorCount()) * 15.0);
    }
}

