/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines.furnace;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerElectricFurnace;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.Voltaic;
import voltaic.common.item.ItemUpgrade;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileElectricFurnace
extends GenericTile
implements ITickableSound {
    protected SmeltingRecipe[] cachedRecipe = null;
    private List<SmeltingRecipe> cachedRecipes = null;
    private boolean isSoundPlaying = false;
    private final int procCount;

    public TileElectricFurnace(BlockPos worldPosition, BlockState blockState) {
        this((BlockEntityType)ElectrodynamicsTiles.TILE_ELECTRICFURNACE.get(), 1, worldPosition, blockState);
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.electricfurnace.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerElectricFurnace((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public TileElectricFurnace(BlockEntityType<?> type, int procCount, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.procCount = procCount;
        int inputsPerProc = 1;
        int outputPerProc = 1;
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).voltage(120.0 * Math.pow(2.0, procCount - 1)).maxJoules(ElectroConstants.ELECTRICFURNACE_USAGE_PER_TICK * 20.0 * (double)procCount));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(procCount, inputsPerProc, outputPerProc, 0).upgrades(3)).validUpgrades(ContainerElectricFurnace.VALID_UPGRADES).valid(TileElectricFurnace.machineValidator()).implementMachineInputsAndOutputs());
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this, procCount).canProcess(this::canProcess).process(this::process));
        this.cachedRecipe = new SmeltingRecipe[procCount];
    }

    protected boolean canProcess(ComponentProcessor component, int procNumber) {
        boolean canProcess = this.checkConditions(component, procNumber);
        if (BlockEntityUtils.isLit((GenericTile)this) ^ (canProcess || component.isAnyActive()) || component.isActive(procNumber)) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)(canProcess || component.isActive(procNumber) ? 1 : 0));
        }
        return canProcess;
    }

    private boolean checkConditions(ComponentProcessor component, int procNumber) {
        component.setShouldKeepProgress(true, procNumber);
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack input = (ItemStack)inv.getInputsForProcessor(procNumber).get(0);
        if (input.m_41619_()) {
            component.setShouldKeepProgress(false, procNumber);
            component.operatingTicks.setValue((Object)0.0, procNumber);
            component.usage(0.0, procNumber);
            return false;
        }
        this.cachedRecipes = this.f_58857_.m_7465_().m_44013_(RecipeType.f_44108_);
        if (this.cachedRecipes == null) {
            // empty if block
        }
        if (this.cachedRecipe == null) {
            component.setShouldKeepProgress(false, procNumber);
            component.operatingTicks.setValue((Object)0.0, procNumber);
            component.usage(0.0, procNumber);
            return false;
        }
        if (this.cachedRecipe[procNumber] == null) {
            this.cachedRecipe[procNumber] = this.getMatchedRecipe(input);
            if (this.cachedRecipe[procNumber] == null) {
                component.setShouldKeepProgress(false, procNumber);
                component.operatingTicks.setValue((Object)0.0, procNumber);
                component.usage(0.0, procNumber);
                return false;
            }
        }
        if (!this.cachedRecipe[procNumber].m_5818_((Container)new SimpleContainer(new ItemStack[]{input}), this.f_58857_)) {
            this.cachedRecipe[procNumber] = null;
            component.setShouldKeepProgress(false, procNumber);
            component.operatingTicks.setValue((Object)0.0, procNumber);
            component.usage(0.0, procNumber);
            return false;
        }
        component.usage.setValue((Object)ElectroConstants.ELECTRICFURNACE_USAGE_PER_TICK, procNumber);
        component.requiredTicks.setValue((Object)ElectroConstants.ELECTRICFURNACE_REQUIRED_TICKS, procNumber);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < component.getUsage(procNumber) * (Double)component.operatingSpeed.getValue()) {
            return false;
        }
        ItemStack output = (ItemStack)inv.getOutputContents().get(procNumber);
        ItemStack result = this.cachedRecipe[procNumber].m_8043_(this.f_58857_.m_9598_());
        return (output.m_41619_() || output.m_41720_() == result.m_41720_()) && output.m_41613_() + result.m_41613_() <= output.m_41741_();
    }

    protected void process(ComponentProcessor component, int procNumber) {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack input = (ItemStack)inv.getInputsForProcessor(procNumber).get(0);
        ItemStack output = (ItemStack)inv.getOutputsForProcessor(procNumber).get(0);
        ItemStack result = this.cachedRecipe[procNumber].m_8043_(this.f_58857_.m_9598_());
        int index = (Integer)inv.getOutputSlots().get(procNumber);
        if (!output.m_41619_()) {
            output.m_41764_(output.m_41613_() + result.m_41613_());
            inv.m_6836_(index, output);
        } else {
            inv.m_6836_(index, result.m_41777_());
        }
        input.m_41774_(1);
        inv.m_6836_(((Integer)inv.getInputSlotsForProcessor(procNumber).get(0)).intValue(), input.m_41777_());
        for (ItemStack stack : inv.getUpgradeContents()) {
            if (stack.m_41619_() || ((ItemUpgrade)stack.m_41720_()).subtype != SubtypeItemUpgrade.experience) continue;
            CompoundTag tag = stack.m_41784_();
            tag.m_128347_("xp", tag.m_128459_("xp") + (double)this.cachedRecipe[procNumber].m_43750_());
            break;
        }
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!((ComponentProcessor)this.getComponent(IComponentType.Processor)).isAnyActive()) {
            return;
        }
        double threshhold = 0.15;
        if (this.procCount == 2) {
            threshhold = 0.2;
        } else if (this.procCount == 3) {
            threshhold = 0.3;
        }
        double random = this.f_58857_.f_46441_.m_188500_();
        if (random < threshhold) {
            Direction direction = this.getFacing();
            double axisShift = 0.0;
            double yShift = 0.0;
            switch (this.procCount) {
                case 1: {
                    double xShift;
                    axisShift = Voltaic.RANDOM.nextDouble(0.64) + 0.18;
                    yShift = Voltaic.RANDOM.nextDouble(0.57) + 0.25;
                    double d = direction.m_122434_() == Direction.Axis.X ? (double)(direction.m_122429_() * (direction.m_122429_() == -1 ? 0 : 1)) : (xShift = axisShift);
                    double zShift = direction.m_122434_() == Direction.Axis.Z ? (double)(direction.m_122431_() * (direction.m_122431_() == -1 ? 0 : 1)) : axisShift;
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_() + zShift, 0.0, 0.0, 0.0);
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_() + zShift, 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    double xShift;
                    int randInt = this.f_58857_.f_46441_.m_216332_(0, 2);
                    axisShift = Voltaic.RANDOM.nextDouble(0.64) + 0.18;
                    yShift = Voltaic.RANDOM.nextDouble(0.38) + 0.37;
                    double d = direction.m_122434_() == Direction.Axis.X ? (double)(direction.m_122429_() * (direction.m_122429_() == -1 ? 0 : 1)) : (xShift = axisShift);
                    double zShift = direction.m_122434_() == Direction.Axis.Z ? (double)(direction.m_122431_() * (direction.m_122431_() == -1 ? 0 : 1)) : axisShift;
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_() + zShift, 0.0, 0.0, 0.0);
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_() + zShift, 0.0, 0.0, 0.0);
                    if (randInt == 1) {
                        direction = direction.m_122427_();
                    } else if (randInt == 2) {
                        direction = direction.m_122428_();
                    }
                    axisShift = Voltaic.RANDOM.nextDouble(0.64) + 0.18;
                    yShift = Voltaic.RANDOM.nextDouble(0.38) + 0.37;
                    double d2 = direction.m_122434_() == Direction.Axis.X ? (double)(direction.m_122429_() * (direction.m_122429_() == -1 ? 0 : 1)) : (xShift = axisShift);
                    zShift = direction.m_122434_() == Direction.Axis.Z ? (double)(direction.m_122431_() * (direction.m_122431_() == -1 ? 0 : 1)) : axisShift;
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_() + zShift, 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    double xShift;
                    int randInt = this.f_58857_.f_46441_.m_216332_(0, 2);
                    axisShift = Voltaic.RANDOM.nextDouble(0.64) + 0.18;
                    yShift = Voltaic.RANDOM.nextDouble(0.38) + 0.37;
                    double d = direction.m_122434_() == Direction.Axis.X ? (double)(direction.m_122429_() * (direction.m_122429_() == -1 ? 0 : 1)) : (xShift = axisShift);
                    double zShift = direction.m_122434_() == Direction.Axis.Z ? (double)(direction.m_122431_() * (direction.m_122431_() == -1 ? 0 : 1)) : axisShift;
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_() + zShift, 0.0, 0.0, 0.0);
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_() + zShift, 0.0, 0.0, 0.0);
                    if (randInt == 1) {
                        direction = direction.m_122427_();
                    } else if (randInt == 2) {
                        direction = direction.m_122428_();
                    }
                    axisShift = Voltaic.RANDOM.nextDouble(0.64) + 0.18;
                    yShift = Voltaic.RANDOM.nextDouble(0.38) + 0.37;
                    double d3 = direction.m_122434_() == Direction.Axis.X ? (double)(direction.m_122429_() * (direction.m_122429_() == -1 ? 0 : 1)) : (xShift = axisShift);
                    zShift = direction.m_122434_() == Direction.Axis.Z ? (double)(direction.m_122431_() * (direction.m_122431_() == -1 ? 0 : 1)) : axisShift;
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_() + zShift, 0.0, 0.0, 0.0);
                    break;
                }
            }
        }
        if (!this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_HUM.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isAnyActive();
    }

    private SmeltingRecipe getMatchedRecipe(ItemStack stack) {
        for (SmeltingRecipe recipe : this.cachedRecipes) {
            if (!recipe.m_5818_((Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_)) continue;
            return recipe;
        }
        return null;
    }

    public int getComparatorSignal() {
        return (int)((double)((ComponentProcessor)this.getComponent(IComponentType.Processor)).getTotalActive() / (double)Math.max(1, ((ComponentProcessor)this.getComponent(IComponentType.Processor)).getProcessorCount()) * 15.0);
    }
}

