/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.fluid;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerCreativeFluidSource;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;

public class TileCreativeFluidSource
extends GenericTile {
    public TileCreativeFluidSource(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_CREATIVEFLUIDSOURCE.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentFluidHandlerSimple(128000, (GenericTile)this, "").setOutputDirections(BlockEntityUtils.MachineDirection.values()));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().bucketInputs(1).bucketOutputs(1)).valid((slot, stack, i) -> stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM) != CapabilityUtils.EMPTY_FLUID_ITEM));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.creativefluidsource.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerCreativeFluidSource((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private void tickServer(ComponentTickable tick) {
        IFluidHandlerItem handler;
        ComponentFluidHandlerSimple simple = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack input = inv.m_8020_(0);
        ItemStack output = inv.m_8020_(1);
        simple.setFluid(new FluidStack(simple.getFluid(), simple.getCapacity()));
        if (!input.m_41619_() && (handler = (IFluidHandlerItem)input.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM)) != CapabilityUtils.EMPTY_FLUID_ITEM) {
            simple.setFluid(new FluidStack(handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE), simple.getCapacity()));
        }
        if (!output.m_41619_() && (handler = (IFluidHandlerItem)output.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM)) != CapabilityUtils.EMPTY_FLUID_ITEM) {
            handler.fill(simple.getFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
            inv.m_6836_(1, handler.getContainer());
        }
        Direction facing = this.getFacing();
        for (Direction relative : simple.outputDirections) {
            IFluidHandler handler2;
            Direction direction = BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)relative.m_122424_());
            BlockPos face = this.m_58899_().m_121945_(direction.m_122424_());
            BlockEntity faceTile = this.m_58904_().m_7702_(face);
            if (faceTile == null || (handler2 = (IFluidHandler)faceTile.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).orElse((Object)CapabilityUtils.EMPTY_FLUID)) == CapabilityUtils.EMPTY_FLUID) continue;
            for (PropertyFluidTank fluidTank : simple.asArray()) {
                FluidStack tankFluid = fluidTank.getFluid();
                handler2.fill(tankFluid, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }
}

