/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas.gastransformer;

import electrodynamics.common.settings.ElectroConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.tile.types.GenericGasTile;
import voltaic.prefab.utilities.BlockEntityUtils;

public abstract class GenericTileGasTransformer
extends GenericGasTile
implements ITickableSound {
    protected boolean isSoundPlaying = false;

    public GenericTileGasTransformer(BlockEntityType<?> tileEntityTypeIn, BlockPos worldPos, BlockState blockState) {
        super(tileEntityTypeIn, worldPos, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)this.getInventory());
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).canProcess(this::canProcess).process(this::process).usage(this.getUsagePerTick(), 0));
        this.addComponent((IComponent)new ComponentGasHandlerMulti((GenericTile)this).setTanks(1, GenericTileGasTransformer.arr((int[])new int[]{ElectroConstants.GAS_TRANSFORMER_BASE_INPUT_CAPCITY}), GenericTileGasTransformer.arr((int[])new int[]{ElectroConstants.GAS_TRANSFORMER_INPUT_TEMP_CAP}), GenericTileGasTransformer.arr((int[])new int[]{ElectroConstants.GAS_TRANSFORMER_INPUT_PRESSURE_CAP}), 1, GenericTileGasTransformer.arr((int[])new int[]{ElectroConstants.GAS_TRANSFORMER_BASE_OUTPUT_CAPCITY}), GenericTileGasTransformer.arr((int[])new int[]{ElectroConstants.GAS_TRANSFORMER_OUTPUT_TEMP_CAP}), GenericTileGasTransformer.arr((int[])new int[]{ElectroConstants.GAS_TRANSFORMER_OUTPUT_PRESSURE_CAP})).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.RIGHT}).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT}).setCondensedHandler(this.getCondensedHandler()));
        this.addComponent((IComponent)this.getContainerProvider());
    }

    public abstract boolean canProcess(ComponentProcessor var1, int var2);

    public abstract void process(ComponentProcessor var1, int var2);

    public abstract void tickClient(ComponentTickable var1);

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0);
    }

    public abstract ComponentContainerProvider getContainerProvider();

    public abstract ComponentInventory getInventory();

    public abstract double getUsagePerTick();

    public abstract int getConversionRate();
}

