/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.datagen.server.recipe.types.vanilla;

import electrodynamics.common.block.subtype.SubtypeGlass;
import electrodynamics.common.block.subtype.SubtypeOre;
import electrodynamics.common.item.subtype.SubtypeCeramic;
import electrodynamics.common.item.subtype.SubtypeDust;
import electrodynamics.common.item.subtype.SubtypeIngot;
import electrodynamics.registers.ElectrodynamicsItems;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.Tags;
import voltaic.common.tags.VoltaicTags;
import voltaic.datagen.utils.server.recipe.AbstractRecipeGenerator;
import voltaic.datagen.utils.server.recipe.CustomCookingRecipe;

public class ElectrodynamicsSmeltingRecipes
extends AbstractRecipeGenerator {
    private static final String SMELTING_LOC = "smelting/";
    private static final String BLASTING_LOC = "blasting/";

    public void addRecipes(Consumer<FinishedRecipe> consumer) {
        for (SubtypeDust subtypeDust : SubtypeDust.values()) {
            if (subtypeDust.smeltedItem == null) continue;
            CustomCookingRecipe.smeltingRecipe((Item)subtypeDust.smeltedItem.get(), (float)0.0f, (int)subtypeDust.smeltTime).input(subtypeDust.tag).complete("electrodynamics", SMELTING_LOC + subtypeDust.name() + "_ingot_from_dust", consumer);
            CustomCookingRecipe.blastingRecipe((Item)subtypeDust.smeltedItem.get(), (float)0.0f, (int)(subtypeDust.smeltTime / 2)).input(subtypeDust.tag).complete("electrodynamics", BLASTING_LOC + subtypeDust.name() + "_ingot_from_dust", consumer);
        }
        for (Enum enum_ : SubtypeOre.values()) {
            if (((SubtypeOre)enum_).smeltingItem == null) continue;
            CustomCookingRecipe.smeltingRecipe((Item)((SubtypeOre)enum_).smeltingItem.get(), (float)((float)((SubtypeOre)enum_).smeltingXp), (int)((SubtypeOre)enum_).smeltingTime).input(((SubtypeOre)enum_).itemTag).complete("electrodynamics", SMELTING_LOC + enum_.name() + "_ingot_from_ore", consumer);
            CustomCookingRecipe.blastingRecipe((Item)((SubtypeOre)enum_).smeltingItem.get(), (float)((float)((SubtypeOre)enum_).smeltingXp), (int)(((SubtypeOre)enum_).smeltingTime / 2)).input(((SubtypeOre)enum_).itemTag).complete("electrodynamics", BLASTING_LOC + enum_.name() + "_ingot_from_ore", consumer);
        }
        CustomCookingRecipe.smeltingRecipe((Item)((Item)ElectrodynamicsItems.ITEM_COAL_COKE.get()), (float)0.1f, (int)200).input(ItemTags.f_13160_).complete("electrodynamics", "smelting/coal_coke", consumer);
        CustomCookingRecipe.blastingRecipe((Item)((Item)ElectrodynamicsItems.ITEM_COAL_COKE.get()), (float)0.1f, (int)100).input(ItemTags.f_13160_).complete("electrodynamics", "blasting/coal_coke", consumer);
        CustomCookingRecipe.blastingRecipe((Item)((Item)ElectrodynamicsItems.ITEMS_CERAMIC.getValue((Object)SubtypeCeramic.cooked)), (float)0.1f, (int)300).input((Item)ElectrodynamicsItems.ITEMS_CERAMIC.getValue((Object)SubtypeCeramic.wet)).complete("electrodynamics", "blasting/cooked_ceramic", consumer);
        CustomCookingRecipe.smeltingRecipe((Item)((Item)ElectrodynamicsItems.ITEMS_CUSTOMGLASS.getValue((Object)SubtypeGlass.clear)), (float)0.1f, (int)200).input(VoltaicTags.Items.DUST_SILICA).complete("electrodynamics", "smelting/clear_glass", consumer);
        CustomCookingRecipe.blastingRecipe((Item)((Item)ElectrodynamicsItems.ITEMS_CUSTOMGLASS.getValue((Object)SubtypeGlass.clear)), (float)0.1f, (int)100).input(VoltaicTags.Items.DUST_SILICA).complete("electrodynamics", "blasting/clear_glass", consumer);
        CustomCookingRecipe.blastingRecipe((Item)((Item)ElectrodynamicsItems.ITEMS_INGOT.getValue((Object)SubtypeIngot.steel)), (float)0.1f, (int)100).input(Tags.Items.INGOTS_IRON).complete("electrodynamics", "blasting/steel_ingot_from_iron_ingot", consumer);
        CustomCookingRecipe.smeltingRecipe((Item)((Item)ElectrodynamicsItems.ITEMS_INGOT.getValue((Object)SubtypeIngot.tin)), (float)0.1f, (int)200).input(VoltaicTags.Items.RAW_ORE_TIN).complete("electrodynamics", "smelting/tin_ingot_from_raw_ore", consumer);
        CustomCookingRecipe.blastingRecipe((Item)((Item)ElectrodynamicsItems.ITEMS_INGOT.getValue((Object)SubtypeIngot.tin)), (float)0.1f, (int)100).input(VoltaicTags.Items.RAW_ORE_TIN).complete("electrodynamics", "blasting/tin_ingot_from_raw_ore", consumer);
        CustomCookingRecipe.smeltingRecipe((Item)((Item)ElectrodynamicsItems.ITEMS_INGOT.getValue((Object)SubtypeIngot.silver)), (float)0.7f, (int)200).input(VoltaicTags.Items.RAW_ORE_SILVER).complete("electrodynamics", "smelting/silver_ingot_from_raw_ore", consumer);
        CustomCookingRecipe.blastingRecipe((Item)((Item)ElectrodynamicsItems.ITEMS_INGOT.getValue((Object)SubtypeIngot.silver)), (float)0.7f, (int)100).input(VoltaicTags.Items.RAW_ORE_SILVER).complete("electrodynamics", "blasting/silver_ingot_from_raw_ore", consumer);
        CustomCookingRecipe.smeltingRecipe((Item)((Item)ElectrodynamicsItems.ITEMS_INGOT.getValue((Object)SubtypeIngot.lead)), (float)0.7f, (int)200).input(VoltaicTags.Items.RAW_ORE_LEAD).complete("electrodynamics", "smelting/lead_ingot_from_raw_ore", consumer);
        CustomCookingRecipe.blastingRecipe((Item)((Item)ElectrodynamicsItems.ITEMS_INGOT.getValue((Object)SubtypeIngot.lead)), (float)0.7f, (int)100).input(VoltaicTags.Items.RAW_ORE_LEAD).complete("electrodynamics", "blasting/lead_ingot_from_raw_ore", consumer);
    }
}

