/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.io.item.MultiSlotAccess;
import com.enderio.machines.common.io.item.SingleSlotAccess;
import com.enderio.machines.common.menu.CrafterMenu;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CrafterBlockEntity
extends PoweredMachineBlockEntity {
    public static final QuadraticScalable ENERGY_CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.CRAFTER_CAPACITY);
    public static final QuadraticScalable ENERGY_USAGE = new QuadraticScalable(CapacitorModifier.ENERGY_USE, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.CRAFTER_USAGE);
    public static final MultiSlotAccess INPUT = new MultiSlotAccess();
    public static final SingleSlotAccess OUTPUT = new SingleSlotAccess();
    public static final MultiSlotAccess GHOST = new MultiSlotAccess();
    public static final SingleSlotAccess PREVIEW = new SingleSlotAccess();
    @Nullable
    private CraftingRecipe recipe;
    private final Queue<ItemStack> outputBuffer = new ArrayDeque<ItemStack>();

    public CrafterBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Input, ENERGY_CAPACITY, ENERGY_USAGE, type, worldPosition, blockState);
        this.getInventoryNN().addSlotChangedCallback(this::onSlotChanged);
    }

    private CrafterContainer getPopulatedCraftingContainer(MultiSlotAccess sourceSlots) {
        CrafterContainer container = new CrafterContainer();
        for (int i = 0; i < 9; ++i) {
            container.m_6836_(i, sourceSlots.get(i).getItemStack(this).m_41777_());
        }
        return container;
    }

    private void onSlotChanged(int slot) {
        if (GHOST.contains(slot)) {
            this.updateRecipe();
        }
    }

    private void updateRecipe() {
        CrafterContainer container = this.getPopulatedCraftingContainer(GHOST);
        this.recipe = this.m_58904_().m_7465_().m_44015_(RecipeType.f_44107_, (Container)container, this.m_58904_()).orElse(null);
        PREVIEW.setStackInSlot(this, ItemStack.f_41583_);
        if (this.recipe != null) {
            PREVIEW.setStackInSlot(this, this.recipe.m_8043_(this.m_58904_().m_9598_()));
        }
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new CrafterMenu(this, inventory, containerId);
    }

    @Override
    public MachineInventoryLayout createInventoryLayout() {
        return MachineInventoryLayout.builder().capacitor().setStackLimit(1).inputSlot(9, this::acceptSlotInput).slotAccess(INPUT).setStackLimit(64).outputSlot(1).slotAccess(OUTPUT).setStackLimit(1).ghostSlot(9).slotAccess(GHOST).previewSlot().slotAccess(PREVIEW).build();
    }

    private boolean acceptSlotInput(int slot, ItemStack stack) {
        return ItemStack.m_41656_((ItemStack)this.getInventoryNN().getStackInSlot(slot + 10), (ItemStack)stack);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.updateRecipe();
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.updateRecipe();
        }
    }

    @Override
    public void serverTick() {
        if (this.canAct()) {
            this.tryCraft();
        }
        super.serverTick();
        this.processOutputBuffer();
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && this.hasEnergy();
    }

    private void tryCraft() {
        this.getRecipeResult().ifPresent(result -> {
            if (this.shouldActTick() && this.hasPowerToCraft() && this.canMergeOutput((ItemStack)result) && this.outputBuffer.isEmpty()) {
                this.craftItem();
            }
        });
    }

    private boolean shouldActTick() {
        return this.canAct() && this.f_58857_.m_46467_() % (long)this.ticksForAction() == 0L;
    }

    private int ticksForAction() {
        return 20;
    }

    private boolean hasPowerToCraft() {
        return this.energyStorage.consumeEnergy((Integer)MachinesConfig.COMMON.ENERGY.CRAFTING_RECIPE_COST.get(), true) >= (Integer)MachinesConfig.COMMON.ENERGY.CRAFTING_RECIPE_COST.get();
    }

    private void processOutputBuffer() {
        if (this.outputBuffer.isEmpty()) {
            return;
        }
        if (this.canMergeOutput(this.outputBuffer.peek())) {
            ItemStack stack = OUTPUT.getItemStack(this);
            if (stack.m_41619_()) {
                OUTPUT.setStackInSlot(this, this.outputBuffer.peek().m_41777_());
            } else {
                stack.m_41769_(this.outputBuffer.peek().m_41613_());
            }
            this.outputBuffer.remove();
        }
    }

    private Optional<ItemStack> getRecipeResult() {
        CrafterContainer container = this.getPopulatedCraftingContainer(INPUT);
        if (this.recipe != null && this.recipe.m_5818_((Container)container, this.m_58904_())) {
            return Optional.of(this.recipe.m_5874_((Container)container, this.m_58904_().m_9598_()));
        }
        return Optional.empty();
    }

    private boolean canMergeOutput(ItemStack item) {
        ItemStack output = OUTPUT.getItemStack(this);
        return output.m_41619_() || ItemStack.m_150942_((ItemStack)output, (ItemStack)item) && output.m_41613_() + item.m_41613_() <= 64;
    }

    private void craftItem() {
        for (int i = 0; i < 9; ++i) {
            if (ItemStack.m_41656_((ItemStack)INPUT.get(i).getItemStack(this), (ItemStack)GHOST.get(i).getItemStack(this))) continue;
            return;
        }
        CrafterContainer container = this.getPopulatedCraftingContainer(INPUT);
        this.clearInput();
        this.outputBuffer.add(this.recipe.m_5874_((Container)container, this.m_58904_().m_9598_()));
        this.outputBuffer.addAll((Collection<ItemStack>)this.recipe.m_7457_((Container)container));
        this.outputBuffer.removeIf(ItemStack::m_41619_);
        this.energyStorage.consumeEnergy((Integer)MachinesConfig.COMMON.ENERGY.CRAFTING_RECIPE_COST.get(), false);
        if (this.f_58857_.m_7465_().m_44043_(this.recipe.m_6423_()).orElse(null) != this.recipe) {
            this.recipe = null;
        }
    }

    private void clearInput() {
        for (int i = 0; i < 9; ++i) {
            INPUT.get(i).setStackInSlot(this, ItemStack.f_41583_);
        }
    }

    private static class CrafterContainer
    extends TransientCraftingContainer {
        public CrafterContainer() {
            super(new AbstractContainerMenu(null, -1){

                public ItemStack m_7648_(Player pPlayer, int pIndex) {
                    return ItemStack.f_41583_;
                }

                public boolean m_6875_(Player pPlayer) {
                    return false;
                }
            }, 3, 3);
        }
    }
}

