/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public final class CheckeredPanelSegmentShapes {
    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        VoxelShape shapeFirst = ShapeUtils.orUnoptimized(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0));
        VoxelShape shapeSecond = ShapeUtils.orUnoptimized(Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0));
        VoxelShape[] shapes = new VoxelShape[8];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int idx = dir.m_122416_();
            boolean x = Utils.isX(dir);
            shapes[idx] = ShapeUtils.rotateShape(Direction.NORTH, dir, x ? shapeSecond : shapeFirst);
            shapes[idx + 4] = ShapeUtils.rotateShape(Direction.NORTH, dir, x ? shapeFirst : shapeSecond);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean second = (Boolean)state.m_61143_((Property)PropertyHolder.SECOND);
            int idx = dir.m_122416_() + (second ? 4 : 0);
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private CheckeredPanelSegmentShapes() {
    }
}

