/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fission;

import java.util.EnumSet;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class TileEntityFissionReactorLogicAdapter
extends TileEntityFissionReactorCasing
implements IReactorLogic<FissionReactorLogic> {
    public FissionReactorLogic logicType = FissionReactorLogic.DISABLED;
    private RedstoneStatus prevStatus = RedstoneStatus.IDLE;

    public TileEntityFissionReactorLogicAdapter(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER, pos, state);
    }

    @Override
    protected boolean onUpdateServer(FissionReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer(multiblock);
        RedstoneStatus status = this.getStatus();
        if (status != this.prevStatus) {
            Level world = this.m_58904_();
            if (world != null) {
                Direction side = multiblock.getOutsideSide(this.f_58858_);
                if (side == null) {
                    world.m_46672_(this.m_58899_(), this.getBlockType());
                } else if (!ForgeEventFactory.onNeighborNotify((Level)world, (BlockPos)this.f_58858_, (BlockState)this.m_58900_(), EnumSet.of(side), (boolean)false).isCanceled()) {
                    world.m_46586_(this.f_58858_.m_121945_(side), this.getBlockType(), this.f_58858_);
                }
            }
            this.prevStatus = status;
        }
        return needsPacket;
    }

    @Override
    @ComputerMethod(nameOverride="getLogicMode")
    public FissionReactorLogic getMode() {
        return this.logicType;
    }

    public FissionReactorLogic[] getModes() {
        return FissionReactorLogic.values();
    }

    public int getRedstoneLevel(Direction side) {
        return !this.isRemote() && ((FissionReactorMultiblockData)this.getMultiblock()).isPositionOutsideBounds(this.f_58858_.m_121945_(side)) && this.getStatus() == RedstoneStatus.OUTPUTTING ? 15 : 0;
    }

    @ComputerMethod(nameOverride="getRedstoneLogicStatus")
    public RedstoneStatus getStatus() {
        if (this.isRemote()) {
            return this.prevStatus;
        }
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            switch (this.logicType) {
                case ACTIVATION: {
                    if (!this.isPowered()) break;
                    return RedstoneStatus.POWERED;
                }
                case TEMPERATURE: {
                    if (!(multiblock.heatCapacitor.getTemperature() >= 1200.0)) break;
                    return RedstoneStatus.OUTPUTTING;
                }
                case EXCESS_WASTE: {
                    if (multiblock.wasteTank.getNeeded() != 0L) break;
                    return RedstoneStatus.OUTPUTTING;
                }
                case DAMAGED: {
                    if (!(multiblock.reactorDamage >= 100.0)) break;
                    return RedstoneStatus.OUTPUTTING;
                }
                case DEPLETED: {
                    if (!multiblock.fuelTank.isEmpty()) break;
                    return RedstoneStatus.OUTPUTTING;
                }
            }
        }
        return RedstoneStatus.IDLE;
    }

    @ComputerMethod(nameOverride="setLogicMode")
    public void setLogicTypeFromPacket(FissionReactorLogic logicType) {
        if (this.logicType != logicType) {
            this.logicType = logicType;
            this.markForSave();
        }
    }

    public void onPowerChange() {
        FissionReactorMultiblockData multiblock;
        super.onPowerChange();
        if (!this.isRemote() && (multiblock = (FissionReactorMultiblockData)this.getMultiblock()).isFormed() && this.logicType == FissionReactorLogic.ACTIVATION) {
            multiblock.setActive(this.isPowered());
        }
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        NBTUtils.setEnumIfPresent((CompoundTag)nbt, (String)"logicType", FissionReactorLogic::byIndexStatic, logicType -> {
            this.logicType = logicType;
        });
    }

    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        NBTUtils.writeEnum((CompoundTag)nbtTags, (String)"logicType", (Enum)this.logicType);
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(FissionReactorLogic::byIndexStatic, (Enum)FissionReactorLogic.DISABLED, this::getMode, value -> {
            this.logicType = value;
        }));
        container.track((ISyncableData)SyncableEnum.create(RedstoneStatus::byIndexStatic, (Enum)RedstoneStatus.IDLE, () -> this.prevStatus, value -> {
            this.prevStatus = value;
        }));
    }

    public boolean canBeMaster() {
        return false;
    }

    @NothingNullByDefault
    public static enum FissionReactorLogic implements IReactorLogicMode<FissionReactorLogic>,
    IHasTranslationKey
    {
        DISABLED(GeneratorsLang.REACTOR_LOGIC_DISABLED, GeneratorsLang.DESCRIPTION_REACTOR_DISABLED, new ItemStack((ItemLike)Items.f_42403_), EnumColor.DARK_GRAY),
        ACTIVATION(GeneratorsLang.REACTOR_LOGIC_ACTIVATION, GeneratorsLang.DESCRIPTION_REACTOR_ACTIVATION, new ItemStack((ItemLike)Items.f_42409_), EnumColor.AQUA),
        TEMPERATURE(GeneratorsLang.REACTOR_LOGIC_TEMPERATURE, GeneratorsLang.DESCRIPTION_REACTOR_TEMPERATURE, new ItemStack((ItemLike)Items.f_42451_), EnumColor.RED),
        EXCESS_WASTE(GeneratorsLang.REACTOR_LOGIC_EXCESS_WASTE, GeneratorsLang.DESCRIPTION_REACTOR_EXCESS_WASTE, new ItemStack((ItemLike)Items.f_42451_), EnumColor.RED),
        DAMAGED(GeneratorsLang.REACTOR_LOGIC_DAMAGED, GeneratorsLang.DESCRIPTION_REACTOR_DAMAGED, new ItemStack((ItemLike)Items.f_42451_), EnumColor.RED),
        DEPLETED(GeneratorsLang.REACTOR_LOGIC_DEPLETED, GeneratorsLang.DESCRIPTION_REACTOR_DEPLETED, new ItemStack((ItemLike)Items.f_42451_), EnumColor.RED);

        private static final FissionReactorLogic[] MODES;
        private final ILangEntry name;
        private final ILangEntry description;
        private final ItemStack renderStack;
        private final EnumColor color;

        private FissionReactorLogic(ILangEntry name, ILangEntry description, ItemStack stack, EnumColor color) {
            this.name = name;
            this.description = description;
            this.renderStack = stack;
            this.color = color;
        }

        @Override
        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        @Override
        public Component getDescription() {
            return this.description.translate(new Object[0]);
        }

        @Override
        public EnumColor getColor() {
            return this.color;
        }

        public static FissionReactorLogic byIndexStatic(int index) {
            return (FissionReactorLogic)MathUtils.getByIndexMod((Object[])MODES, (int)index);
        }

        static {
            MODES = FissionReactorLogic.values();
        }
    }

    @NothingNullByDefault
    public static enum RedstoneStatus implements IHasTranslationKey
    {
        IDLE((ILangEntry)MekanismLang.IDLE),
        OUTPUTTING(GeneratorsLang.REACTOR_LOGIC_OUTPUTTING),
        POWERED(GeneratorsLang.REACTOR_LOGIC_POWERED);

        private static final RedstoneStatus[] MODES;
        private final ILangEntry name;

        private RedstoneStatus(ILangEntry name) {
            this.name = name;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        public static RedstoneStatus byIndexStatic(int index) {
            return (RedstoneStatus)((Object)MathUtils.getByIndexMod((Object[])MODES, (int)index));
        }

        static {
            MODES = RedstoneStatus.values();
        }
    }
}

