/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.api.security.ISecurityUtils;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.security.item.ItemStackOwnerObject;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.item.CapabilityItem;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import meranha.mekaweapons.MekaWeapons;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ItemMagnetizer
extends CapabilityItem
implements IFrequencyItem,
IGuiItem {
    public ItemMagnetizer(Item.Properties properties) {
        super(properties.m_41497_(Rarity.RARE).m_41487_(1));
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        ISecurityUtils.INSTANCE.addSecurityTooltip(stack, tooltip);
        MekanismUtils.addFrequencyItemTooltip((ItemStack)stack, tooltip);
        super.m_7373_(stack, world, tooltip, flag);
    }

    public void m_6883_(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        ItemStack slot;
        if (level.m_5776_() || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Frequency frequency = this.getFrequency(stack);
        if (frequency == null || frequency.getType() != FrequencyType.INVENTORY) {
            return;
        }
        IEnergyContainer frequencyContainer = ((InventoryFrequency)frequency).storedEnergy;
        FloatingLong toCharge = (FloatingLong)MekaWeapons.general.wirelessChargerEnergyRate.get();
        if (toCharge.isZero()) {
            return;
        }
        Iterator iterator = player.m_150109_().f_35974_.iterator();
        while (iterator.hasNext() && !(toCharge = this.charge(frequencyContainer, slot = (ItemStack)iterator.next(), toCharge)).isZero()) {
        }
        if (!toCharge.isZero() && Mekanism.hooks.CuriosLoaded) {
            Optional curiosInventory = CuriosIntegration.getCuriosInventory((LivingEntity)player);
            if (curiosInventory.isEmpty()) {
                return;
            }
            IItemHandler handler = (IItemHandler)curiosInventory.get();
            int slots = handler.getSlots();
            for (int slot2 = 0; slot2 < slots && !(toCharge = this.charge(frequencyContainer, handler.getStackInSlot(slot2), toCharge)).isZero(); ++slot2) {
            }
        }
    }

    private FloatingLong charge(IEnergyContainer energyContainer, ItemStack stack, FloatingLong amount) {
        FloatingLong remaining;
        IStrictEnergyHandler handler;
        if (!stack.m_41619_() && !amount.isZero() && (handler = EnergyCompatUtils.getStrictEnergyHandler((ItemStack)stack)) != null && (remaining = handler.insertEnergy(amount, Action.SIMULATE)).smallerThan(amount)) {
            FloatingLong toExtract = amount.subtract(remaining);
            FloatingLong extracted = energyContainer.extract(toExtract, Action.EXECUTE, AutomationType.MANUAL);
            FloatingLong inserted = handler.insertEnergy(extracted, Action.EXECUTE);
            return inserted.add(remaining);
        }
        return amount;
    }

    public FrequencyType<?> getFrequencyType() {
        return FrequencyType.INVENTORY;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        return SecurityUtils.get().claimOrOpenGui(world, player, hand, (arg_0, arg_1, arg_2) -> this.getContainerType().tryOpenGui(arg_0, arg_1, arg_2));
    }

    public ContainerTypeRegistryObject<?> getContainerType() {
        return MekaWeapons.MAGNETIZER_CONTAINER;
    }

    protected void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack, CompoundTag nbt) {
        capabilities.add((ItemCapabilityWrapper.ItemCapability)new ItemStackOwnerObject());
        super.gatherCapabilities(capabilities, stack, nbt);
    }
}

