/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items.modules;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.radial.IRadialDataHelper;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.radial.mode.NestedRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.MekaWeaponsUtils;
import meranha.mekaweapons.WeaponsLang;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public class WeaponAttackAmplificationUnit
implements ICustomModule<WeaponAttackAmplificationUnit> {
    private static final ResourceLocation RADIAL_ID = MekaWeapons.rl("attack_damage");
    private static final Int2ObjectMap<Lazy<NestedRadialMode>> RADIAL_DATAS = (Int2ObjectMap)Util.m_137537_(() -> {
        int types = AttackDamage.values().length - 2;
        Int2ObjectArrayMap map = new Int2ObjectArrayMap(types);
        for (int type = 1; type <= types; ++type) {
            int accessibleValues = type + 2;
            map.put(type, (Object)Lazy.of(() -> new NestedRadialMode(IRadialDataHelper.INSTANCE.dataForTruncated(RADIAL_ID, accessibleValues, (Enum)AttackDamage.MED), (ILangEntry)WeaponsLang.RADIAL_ATTACK_DAMAGE, AttackDamage.MED.icon(), EnumColor.RED)));
        }
        return map;
    });
    private IModuleConfigItem<AttackDamage> attackDamage;

    public void init(IModule<WeaponAttackAmplificationUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.attackDamage = configItemCreator.createConfigItem("attack_damage", (ILangEntry)WeaponsLang.RADIAL_ATTACK_DAMAGE, (ModuleConfigData)new ModuleEnumData((Enum)AttackDamage.MED, module.getInstalledCount() + 2));
    }

    @NotNull
    private NestedRadialMode getNestedData(IModule<WeaponAttackAmplificationUnit> module) {
        return (NestedRadialMode)((Lazy)RADIAL_DATAS.get(module.getInstalledCount())).get();
    }

    @NotNull
    private RadialData<?> getRadialData(IModule<WeaponAttackAmplificationUnit> module) {
        return this.getNestedData(module).nestedData();
    }

    public void addRadialModes(IModule<WeaponAttackAmplificationUnit> module, ItemStack stack, Consumer<NestedRadialMode> adder) {
        adder.accept(this.getNestedData(module));
    }

    @Nullable
    public <MODE extends IRadialMode> MODE getMode(IModule<WeaponAttackAmplificationUnit> module, ItemStack stack, RadialData<MODE> radialData) {
        return (MODE)(radialData == this.getRadialData(module) ? (IRadialMode)this.attackDamage.get() : null);
    }

    public <MODE extends IRadialMode> boolean setMode(IModule<WeaponAttackAmplificationUnit> module, Player player, ItemStack stack, RadialData<MODE> radialData, MODE mode) {
        if (radialData == this.getRadialData(module)) {
            AttackDamage newMode = (AttackDamage)mode;
            if (this.attackDamage.get() != newMode) {
                this.attackDamage.set((Object)newMode);
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Component getModeScrollComponent(IModule<WeaponAttackAmplificationUnit> module, ItemStack stack) {
        AttackDamage atkDmg = (AttackDamage)((Object)this.attackDamage.get());
        return MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(EnumColor.INDIGO, new Object[]{atkDmg.sliceName(), EnumColor.AQUA, this.getCurrentMaxDamage(stack)});
    }

    public void changeMode(IModule<WeaponAttackAmplificationUnit> module, Player player, ItemStack stack, int shift, boolean displayChangeMessage) {
        AttackDamage newMode;
        AttackDamage atkDmg = (AttackDamage)((Object)this.attackDamage.get());
        if (atkDmg != (newMode = (AttackDamage)atkDmg.adjust(shift, v -> v.ordinal() < module.getInstalledCount() + 2))) {
            if (displayChangeMessage) {
                module.displayModeChange(player, (Component)MekanismLang.MODULE_EFFICIENCY.translate(new Object[0]), (IHasTextComponent)newMode);
            }
            this.attackDamage.set((Object)newMode);
        }
    }

    public void addHUDStrings(IModule<WeaponAttackAmplificationUnit> module, Player player, Consumer<Component> hudStringAdder) {
        if (module.isEnabled()) {
            hudStringAdder.accept((Component)MekanismLang.MODULE_DAMAGE.translateColored(EnumColor.DARK_GRAY, new Object[]{EnumColor.INDIGO, this.getCurrentMaxDamage(player.m_21205_())}));
        }
    }

    public int getCurrentUnit() {
        return ((AttackDamage)((Object)this.attackDamage.get())).ordinal();
    }

    private int getCurrentMaxDamage(ItemStack stack) {
        return MekaWeaponsUtils.getBaseDamage(stack) * this.getCurrentUnit();
    }

    @NothingNullByDefault
    public static enum AttackDamage implements IIncrementalEnum<AttackDamage>,
    IHasTextComponent,
    IRadialMode,
    StringRepresentable
    {
        OFF(WeaponsLang.RADIAL_TOGGLE_OFF, EnumColor.WHITE, "damage_off"),
        LOW(WeaponsLang.RADIAL_ATTACK_DAMAGE_LOW, EnumColor.PINK, "damage_low"),
        MED(WeaponsLang.RADIAL_ATTACK_DAMAGE_MEDIUM, EnumColor.BRIGHT_GREEN, "damage_medium"),
        HIGH(WeaponsLang.RADIAL_ATTACK_DAMAGE_HIGH, EnumColor.YELLOW, "damage_high"),
        SUPER_HIGH(WeaponsLang.RADIAL_ATTACK_DAMAGE_SUPER, EnumColor.ORANGE, "damage_super"),
        EXTREME(WeaponsLang.RADIAL_ATTACK_DAMAGE_EXTREME, EnumColor.RED, "damage_extreme");

        public static final IntFunction<AttackDamage> BY_ID;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final ResourceLocation icon;
        private final Component label;
        private final Component sliceNamePreCalc;

        private AttackDamage(ILangEntry langEntry, EnumColor color, String texture) {
            this.icon = MekaWeapons.getResource(MekanismUtils.ResourceType.GUI_RADIAL, texture + ".png");
            this.label = TextComponentUtil.getString((String)Integer.toString(this.ordinal()));
            this.sliceNamePreCalc = langEntry.translateColored(color, new Object[0]);
        }

        public AttackDamage byIndex(int index) {
            return BY_ID.apply(index);
        }

        public Component getTextComponent() {
            return this.label;
        }

        public Component sliceName() {
            return this.sliceNamePreCalc;
        }

        public ResourceLocation icon() {
            return this.icon;
        }

        public String m_7912_() {
            return this.serializedName;
        }

        static {
            BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])AttackDamage.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        }
    }
}

