/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.tag;

import gisellevonbingen.mmp.common.material.MaterialState;
import gisellevonbingen.mmp.common.material.MaterialType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class MMPTags {

    public static class Items {
        public static final Map<MaterialType, Map<MaterialState, TagKey<Item>>> PROCESSING_ITEM_TAGS = new HashMap<MaterialType, Map<MaterialState, TagKey<Item>>>();

        public static TagKey<Item> getProcessingItemTag(MaterialType materialType, MaterialState materialState) {
            Map<MaterialState, TagKey<Item>> map = PROCESSING_ITEM_TAGS.get((Object)materialType);
            return map != null ? map.get((Object)materialState) : null;
        }

        public static void initialize() {
            for (MaterialType materialType : MaterialType.values()) {
                HashMap<MaterialState, TagKey> map2 = new HashMap<MaterialState, TagKey>();
                PROCESSING_ITEM_TAGS.put(materialType, map2);
                for (MaterialState materialState : materialType.getResultShape().getProcessableStates()) {
                    if (!materialState.hasOwnItem()) continue;
                    TagKey tag = ItemTags.create((ResourceLocation)materialState.getStateTagName(materialType));
                    map2.put(materialState, tag);
                }
            }
        }

        static {
            Items.initialize();
        }
    }

    public static class Blocks {
    }
}

