/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.utilities.ElectricityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import nuclearscience.api.turbine.ISteamReceiver;
import nuclearscience.common.block.BlockTurbine;
import nuclearscience.registers.NuclearScienceSounds;
import nuclearscience.registers.NuclearScienceTiles;
import org.jetbrains.annotations.NotNull;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileTurbine
extends GenericTile
implements ITickableSound,
ISteamReceiver {
    public static final int MAX_STEAM = 3000000;
    public SingleProperty<Integer> spinSpeed = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "spinSpeed", (Object)0));
    public SingleProperty<Boolean> hasCore = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasCore", (Object)false));
    public SingleProperty<Boolean> isCore = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isCore", (Object)false));
    public SingleProperty<BlockPos> coreLocation = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "coreLocation", (Object)BlockEntityUtils.OUT_OF_REACH));
    public SingleProperty<Integer> currentVoltage = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "turbinecurvoltage", (Object)0));
    public SingleProperty<Integer> steam = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "steam", (Object)0));
    public SingleProperty<Integer> wait = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "wait", (Object)30));
    protected CachedTileOutput output;
    private boolean isSoundPlaying = false;
    private boolean destroyed = false;

    public TileTurbine(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_TURBINE.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP}).setCapabilityTest(() -> (Boolean)this.hasCore.getValue() == false || (Boolean)this.isCore.getValue() != false));
    }

    public void constructStructure() {
        int j;
        int i;
        int radius = 1;
        for (i = -radius; i <= radius; ++i) {
            for (j = -radius; j <= radius; ++j) {
                if (i == 0 && j == 0) continue;
                BlockEntity tile = this.f_58857_.m_7702_(new BlockPos(this.f_58858_.m_123341_() + i, this.f_58858_.m_123342_(), this.f_58858_.m_123343_() + j));
                if (tile instanceof TileTurbine) {
                    TileTurbine turbine = (TileTurbine)tile;
                    if (!((Boolean)turbine.hasCore.getValue()).booleanValue()) continue;
                }
                return;
            }
        }
        this.isCore.setValue((Object)true);
        for (i = -radius; i <= radius; ++i) {
            for (j = -radius; j <= radius; ++j) {
                BlockPos offset = new BlockPos(this.f_58858_.m_123341_() + i, this.f_58858_.m_123342_(), this.f_58858_.m_123343_() + j);
                ((TileTurbine)this.f_58857_.m_7702_(offset)).addToStructure(this);
                BlockState state = this.f_58857_.m_8055_(offset);
                this.f_58857_.m_46597_(offset, (BlockState)state.m_61124_((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void deconstructStructure() {
        TileTurbine core;
        if (((Boolean)this.isCore.getValue()).booleanValue()) {
            int radius = 1;
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    BlockPos offset;
                    BlockEntity tile;
                    if (i == 0 && j == 0 || !((tile = this.f_58857_.m_7702_(offset = new BlockPos(this.f_58858_.m_123341_() + i, this.f_58858_.m_123342_(), this.f_58858_.m_123343_() + j))) instanceof TileTurbine)) continue;
                    TileTurbine turbine = (TileTurbine)tile;
                    turbine.hasCore.setValue((Object)false);
                    turbine.coreLocation.setValue((Object)new BlockPos(0, 0, 0));
                    BlockState state = this.f_58857_.m_8055_(offset);
                    if (!state.m_61138_((Property)BlockTurbine.RENDER)) continue;
                    this.f_58857_.m_46597_(offset, (BlockState)state.m_61124_((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(true)));
                }
            }
            this.isCore.setValue((Object)false);
            this.hasCore.setValue((Object)false);
            this.coreLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
            BlockState state = this.m_58900_();
            if (state.m_61138_((Property)BlockTurbine.RENDER) && !this.destroyed) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(true)));
            }
        } else if (((Boolean)this.hasCore.getValue()).booleanValue() && (core = (TileTurbine)this.f_58857_.m_7702_((BlockPos)this.coreLocation.getValue())) != null) {
            core.deconstructStructure();
        }
    }

    protected void addToStructure(TileTurbine core) {
        this.coreLocation.setValue((Object)core.f_58858_);
        this.hasCore.setValue((Object)true);
    }

    public void tickServer(ComponentTickable tickable) {
        ((ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic)).voltage((double)((Integer)this.currentVoltage.getValue()).intValue());
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(Direction.UP));
        }
        this.spinSpeed.setValue((Object)((Integer)this.currentVoltage.getValue() / 120));
        this.output.update(this.f_58858_.m_121945_(Direction.UP));
        if (((Boolean)this.hasCore.getValue()).booleanValue() && !((Boolean)this.isCore.getValue()).booleanValue()) {
            this.currentVoltage.setValue((Object)0);
            return;
        }
        if ((Integer)this.steam.getValue() > 0 && (Integer)this.currentVoltage.getValue() > 0) {
            this.wait.setValue((Object)30);
            if (this.output.valid()) {
                TransferPack transfer = TransferPack.joulesVoltage((double)((double)((Integer)this.steam.getValue()).intValue() * ((Boolean)this.hasCore.getValue() != false ? 1.111 : 1.0)), (double)((Integer)this.currentVoltage.getValue()).intValue());
                ElectricityUtils.receivePower((BlockEntity)((BlockEntity)this.output.getSafe()), (Direction)Direction.DOWN, (TransferPack)transfer, (boolean)false);
                this.steam.setValue((Object)Math.max((Integer)this.steam.getValue() - Math.max(75, (Integer)this.steam.getValue()), 0));
            }
        } else {
            if ((Integer)this.wait.getValue() <= 0) {
                this.currentVoltage.setValue((Object)0);
                this.wait.setValue((Object)30);
            }
            this.wait.setValue((Object)((Integer)this.wait.getValue() - 1));
        }
    }

    public void tickClient(ComponentTickable tickable) {
        if (!this.isSoundPlaying && this.shouldPlaySound()) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)NuclearScienceSounds.SOUND_TURBINE.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Integer)this.spinSpeed.getValue() > 0;
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    @Override
    public int receiveSteam(int temperature, int amount) {
        BlockEntity core;
        int room = 3000000 * ((Boolean)this.isCore.getValue() != false ? 9 : 1) - (Integer)this.steam.getValue();
        int accepted = room < amount ? room : amount;
        this.steam.setValue((Object)((Integer)this.steam.getValue() + accepted));
        if (temperature < 4300) {
            this.currentVoltage.setValue((Object)120);
        } else if (temperature < 6000) {
            this.currentVoltage.setValue((Object)240);
        } else {
            this.currentVoltage.setValue((Object)480);
        }
        if (!((Boolean)this.isCore.getValue()).booleanValue() && ((Boolean)this.hasCore.getValue()).booleanValue() && (core = this.f_58857_.m_7702_((BlockPos)this.coreLocation.getValue())) instanceof TileTurbine) {
            TileTurbine turbine = (TileTurbine)core;
            if (((Boolean)((TileTurbine)core).isCore.getValue()).booleanValue()) {
                accepted = turbine.receiveSteam(temperature, amount);
                this.steam.setValue((Object)0);
            }
        }
        return accepted;
    }

    @Override
    public boolean isStillValid() {
        return this.m_58901_();
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.destroyed = true;
        this.deconstructStructure();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && !((Boolean)this.m_58900_().m_61143_((Property)BlockTurbine.RENDER)).booleanValue() && !((Boolean)this.isCore.getValue()).booleanValue()) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public AABB getRenderBoundingBox() {
        return (Boolean)this.isCore.getValue() != false ? super.getRenderBoundingBox().m_82377_(1.0, 0.0, 1.0) : super.getRenderBoundingBox();
    }
}

