/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.event;

import forge.NuminaObjLoader;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import lehjr.numina.client.event.FOVUpdateEventHandler;
import lehjr.numina.client.event.ModelBakeEventHandler;
import lehjr.numina.client.event.ToolTipEvent;
import lehjr.numina.client.gui.NuminaIcons;
import lehjr.numina.client.gui.overlay.ModeChangingIconOverlay;
import lehjr.numina.client.render.IconUtils;
import lehjr.numina.client.render.entity.NuminaArmorStandRenderer;
import lehjr.numina.client.render.item.NuminaArmorLayer;
import lehjr.numina.client.screen.ArmorStandScreen;
import lehjr.numina.client.screen.ChargingBaseScreen;
import lehjr.numina.common.base.NuminaLogger;
import lehjr.numina.common.base.NuminaObjects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="numina", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventBusSubscriber {
    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)NuminaObjects.ARMOR_STAND__ENTITY_TYPE.get(), NuminaArmorStandRenderer::new);
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent event) {
        TextureAtlas map = event.getAtlas();
        if (map.m_118330_() == InventoryMenu.f_39692_) {
            System.out.println("fixme, sprite upload not fixed yet!!!!");
        }
    }

    @SubscribeEvent
    public static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)FOVUpdateEventHandler.fovToggleKey.get());
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("numina_mode_changing_icon", ModeChangingIconOverlay.MODE_CHANGING_ICON_OVERLAY);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        for (String string : event.getSkins()) {
            ClientEventBusSubscriber.addCustomLayers(EntityType.f_20532_, (PlayerRenderer)event.getSkin(string));
        }
        for (Map.Entry entry : Minecraft.m_91087_().m_91290_().f_114362_.entrySet()) {
            EntityRenderer renderer = (EntityRenderer)entry.getValue();
            if (!(renderer instanceof LivingEntityRenderer)) continue;
            EntityType entityType = (EntityType)entry.getKey();
            ClientEventBusSubscriber.addCustomLayers(entityType, event.getRenderer(entityType));
        }
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>> void addCustomLayers(EntityType<?> type, @Nullable LivingEntityRenderer<T, M> renderer) {
        if (renderer == null) {
            return;
        }
        HumanoidArmorLayer bipedArmorLayer = null;
        boolean hasElytra = false;
        for (RenderLayer layerRenderer : renderer.f_115291_) {
            if (layerRenderer == null) continue;
            Class<?> layerClass = layerRenderer.getClass();
            if (layerClass == HumanoidArmorLayer.class) {
                bipedArmorLayer = (HumanoidArmorLayer)layerRenderer;
                if (!hasElytra) continue;
                break;
            }
            if (layerClass != ElytraLayer.class) continue;
            hasElytra = true;
            if (bipedArmorLayer == null) continue;
            break;
        }
        if (bipedArmorLayer != null) {
            renderer.m_115326_(new NuminaArmorLayer<T, M, HumanoidModel>(renderer, bipedArmorLayer.f_117071_, bipedArmorLayer.f_117072_, Minecraft.m_91087_().m_91304_()));
        }
    }

    @SubscribeEvent
    public static void onAddAdditional(ModelEvent.RegisterAdditional e) {
        NuminaLogger.logDebug("adding additional models");
        ModelBakeEventHandler.INSTANCE.onAddAdditional(e);
    }

    @SubscribeEvent
    public static void onRegisterReloadListenerEvent(RegisterClientReloadListenersEvent event) {
        NuminaIcons icon = IconUtils.INSTANCE.getIcon();
        System.out.println("reload listener " + Objects.isNull((Object)icon.getSpriteUploader()));
        event.registerReloadListener((PreparableReloadListener)icon.getSpriteUploader());
    }

    @SubscribeEvent
    public static void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new FOVUpdateEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ToolTipEvent());
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)NuminaObjects.CHARGING_BASE_CONTAINER_TYPE.get()), ChargingBaseScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)NuminaObjects.ARMOR_STAND_CONTAINER_TYPE.get()), ArmorStandScreen::new);
        });
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register(ClientEventBusSubscriber.class);
        modEventBus.addListener(ModelBakeEventHandler.INSTANCE::onAddAdditional);
    }

    @SubscribeEvent
    public static void modelRegistry(ModelEvent.RegisterGeometryLoaders event) {
        event.register("obj", (IGeometryLoader)NuminaObjLoader.INSTANCE);
    }
}

