/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lehjr.numina.client.gui.IContainerULOffSet;
import lehjr.numina.client.gui.frame.IGuiFrame;
import lehjr.numina.client.gui.geometry.IRect;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.client.gui.slot.IHideableSlot;
import lehjr.numina.client.gui.slot.IIConProvider;
import lehjr.numina.common.math.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class ExtendedContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IRect {
    protected long creationTime;
    private List<IGuiFrame> frames = new ArrayList<IGuiFrame>();
    protected IRect belowMe;
    protected IRect aboveMe;
    protected IRect leftOfMe;
    protected IRect rightOfMe;

    public ExtendedContainerScreen(T screenAbstractContainerMenu, Inventory inv, Component titleIn) {
        super(screenAbstractContainerMenu, inv, titleIn);
        this.f_96541_ = Minecraft.m_91087_();
    }

    public ExtendedContainerScreen(T screenAbstractContainerMenu, Inventory inv, Component titleIn, int guiWidth, int guiHeight) {
        this(screenAbstractContainerMenu, inv, titleIn);
        this.f_97726_ = guiWidth;
        this.f_97727_ = guiHeight;
    }

    MusePoint2D getUlOffset() {
        return new MusePoint2D(this.getGuiLeft(), this.getGuiTop());
    }

    public IContainerULOffSet.ulGetter ulGetter() {
        return () -> this.getUlOffset();
    }

    public void m_280092_(GuiGraphics gfx, Slot slot) {
        if (slot != null && slot instanceof IHideableSlot) {
            if (slot.m_6659_()) {
                super.m_280092_(gfx, slot);
            }
        } else {
            super.m_280092_(gfx, slot);
        }
        if (slot instanceof IIConProvider && slot.m_7993_().m_41619_() && slot.m_6659_()) {
            gfx.m_280168_().m_85836_();
            gfx.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            ((IIConProvider)slot).drawIconAt(gfx.m_280168_(), slot.f_40220_, slot.f_40221_, Color.WHITE);
            gfx.m_280168_().m_85849_();
        }
    }

    public void m_7856_() {
        super.m_7856_();
        this.frames.clear();
        this.creationTime = System.currentTimeMillis();
    }

    public void addFrame(IGuiFrame frame) {
        this.frames.add(frame);
    }

    protected void m_7286_(GuiGraphics gfx, float partialTick, int mouseX, int mouseY) {
        this.update(mouseX, mouseY);
        this.renderFrames(gfx, mouseX, mouseY, partialTick);
    }

    public void update(double x, double y) {
        this.frames.forEach(frame -> frame.update(x, y));
    }

    public void renderFrames(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        this.frames.forEach(frame -> frame.m_88315_(gfx, mouseX, mouseY, partialTicks));
    }

    public void m_280003_(GuiGraphics gfx, int mouseX, int mouseY) {
        super.m_280003_(gfx, mouseX, mouseY);
        this.renderFrameLabels(gfx, mouseX, mouseY);
    }

    public void renderFrameLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        this.frames.forEach(frame -> frame.renderLabels(gfx, mouseX, mouseY));
    }

    public boolean m_6050_(double mouseX, double mouseY, double dWheel) {
        if (this.frames.stream().anyMatch(frame -> frame.mouseScrolled(mouseX, mouseY, dWheel))) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, dWheel);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.frames.stream().anyMatch(frame -> frame.mouseClicked(mouseX, mouseY, button))) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_97774_(Slot slot, double mouseX, double mouseY) {
        return slot.m_6659_() && this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int which) {
        if (this.frames.stream().anyMatch(frame -> frame.mouseReleased(mouseX, mouseY, which))) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, which);
    }

    public void m_280072_(GuiGraphics gfx, int mouseX, int mouseY) {
        List<Component> tooltip = this.getToolTip(mouseX, mouseY);
        if (tooltip != null) {
            gfx.m_280245_(Minecraft.m_91087_().f_91062_, tooltip.stream().map(Component::m_7532_).collect(Collectors.toList()), mouseX, mouseY);
        }
    }

    public List<Component> getToolTip(int x, int y) {
        for (IGuiFrame frame : this.frames) {
            List<Component> hitTip = frame.getToolTip(x, y);
            if (hitTip == null) continue;
            return hitTip;
        }
        return null;
    }

    public void setXSize(int xSize) {
        this.f_97726_ = xSize;
        this.f_97735_ = (this.f_96543_ - this.getXSize()) / 2;
    }

    public void setYSize(int ySize) {
        this.f_97727_ = ySize;
        this.f_97736_ = (this.f_96544_ - this.getYSize()) / 2;
    }

    @Override
    public MusePoint2D center() {
        return new MusePoint2D(this.getGuiLeft(), this.getGuiTop()).plus((double)this.getXSize() * 0.5, (double)this.getYSize() * 0.5);
    }

    public int absX(double relx) {
        int absx = (int)((relx + 1.0) * (double)this.getXSize() / 2.0);
        int xpadding = (this.f_96543_ - this.getXSize()) / 2;
        return absx + xpadding;
    }

    public int relX(double absx) {
        int padding = (this.f_96543_ - this.getXSize()) / 2;
        return (int)((absx - (double)padding) * 2.0 / (double)this.getXSize() - 1.0);
    }

    public int absY(double rely) {
        int absy = (int)((rely + 1.0) * (double)this.getYSize() / 2.0);
        int ypadding = (this.f_96544_ - this.getYSize()) / 2;
        return absy + ypadding;
    }

    public int relY(float absy) {
        int padding = (this.f_96544_ - this.getYSize()) / 2;
        return (int)((absy - (float)padding) * 2.0f / (float)this.getYSize() - 1.0f);
    }

    public Minecraft getMinecraft() {
        this.f_96541_ = Minecraft.m_91087_();
        return this.f_96541_;
    }

    @Override
    public double left() {
        return this.f_97735_;
    }

    @Override
    public IRect setLeft(double value) {
        this.f_97735_ = (int)value;
        return this;
    }

    @Override
    public double top() {
        return this.f_97736_;
    }

    @Override
    public IRect setTop(double value) {
        this.f_97736_ = (int)value;
        return this;
    }

    @Override
    public double right() {
        return this.left() + (double)this.f_97726_;
    }

    @Override
    public IRect setRight(double value) {
        return this.setLeft(value - (double)this.f_97726_);
    }

    @Override
    public double bottom() {
        return this.top() + (double)this.f_97727_;
    }

    @Override
    public IRect setBottom(double value) {
        return this.setTop(value - (double)this.f_97727_);
    }

    @Override
    public double width() {
        return this.f_97726_;
    }

    @Override
    public IRect setWidth(double value) {
        this.f_97726_ = (int)value;
        return this;
    }

    @Override
    public double height() {
        return this.f_97727_;
    }

    @Override
    public IRect setHeight(double value) {
        this.f_97727_ = (int)value;
        return this;
    }

    @Override
    public void setPosition(MusePoint2D positionIn) {
        IRect.super.setPosition(positionIn);
    }

    @Override
    public MusePoint2D getUL() {
        return new MusePoint2D(this.left(), this.top());
    }

    @Override
    public IRect setUL(MusePoint2D ul) {
        this.setLeft(ul.x());
        this.setTop(ul.y());
        return this;
    }

    @Override
    public MusePoint2D getWH() {
        return new MusePoint2D(this.f_97726_, this.f_97727_);
    }

    @Override
    public IRect setWH(MusePoint2D wh) {
        this.setWidth(wh.x());
        this.setHeight(wh.y());
        return this;
    }

    @Override
    public IRect setAbove(IRect belowMe) {
        this.belowMe = belowMe;
        return this;
    }

    @Override
    public IRect setLeftOf(IRect rightOfMe) {
        this.rightOfMe = rightOfMe;
        return this;
    }

    @Override
    public IRect setBelow(IRect aboveMe) {
        this.aboveMe = aboveMe;
        return this;
    }

    @Override
    public IRect setRightOf(IRect leftOfMe) {
        this.leftOfMe = leftOfMe;
        return this;
    }
}

