/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable;

import com.mojang.blaze3d.platform.Lighting;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.client.gui.clickable.Clickable;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.client.render.IconUtils;
import lehjr.numina.client.render.NuminaRenderer;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.math.Color;
import lehjr.numina.common.string.AdditionalInfo;
import lehjr.numina.common.string.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.registries.ForgeRegistries;

public class ClickableModule
extends Clickable {
    boolean allowed;
    boolean installed = false;
    boolean isEnabled = true;
    boolean isVisible = true;
    ItemStack module;
    int inventorySlot;
    public final ModuleCategory category;
    Integer tier;
    ResourceLocation regName;

    public ClickableModule(@Nonnull ItemStack module, MusePoint2D position, int inventorySlot, ModuleCategory category) {
        super(MusePoint2D.ZERO, new MusePoint2D(16.0, 16.0));
        super.setPosition(position);
        this.module = module;
        this.inventorySlot = inventorySlot;
        this.category = category;
        this.allowed = module.getCapability(NuminaCapabilities.POWER_MODULE).map(pm -> pm.isAllowed()).orElse(false);
        this.tier = module.getCapability(NuminaCapabilities.POWER_MODULE).map(pm -> pm.getTier()).orElse(null);
        this.regName = ForgeRegistries.ITEMS.getKey((Object)module.m_41720_());
    }

    @Nullable
    public Integer getTier() {
        return this.tier;
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }

    @Override
    public List<Component> getToolTip(int x, int y) {
        if (this.containsPoint(x, y)) {
            return this.module.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(AdditionalInfo.doAdditionalInfo() ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
        }
        return null;
    }

    public ResourceLocation getRegName() {
        return this.regName;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        if (!this.getModule().m_41619_()) {
            NuminaRenderer.drawModuleAt(gfx, this.left(), this.top(), this.getModule(), true);
            Lighting.m_84930_();
            if (!this.allowed) {
                gfx.m_280168_().m_85836_();
                gfx.m_280168_().m_252880_(0.0f, 0.0f, 250.0f);
                String string = StringUtils.wrapMultipleFormatTags("X", new Object[]{StringUtils.FormatCodes.Bold, StringUtils.FormatCodes.DarkRed});
                StringUtils.drawShadowedString(gfx, string, this.centerX() + 3.0, this.centerY() + 1.0);
                gfx.m_280168_().m_85849_();
            } else if (this.installed) {
                gfx.m_280168_().m_85836_();
                gfx.m_280168_().m_252880_(0.0f, 0.0f, 250.0f);
                IconUtils.INSTANCE.getIcon().checkmark.draw(gfx.m_280168_(), this.left() + 1.0, this.top() + 1.0, Color.LIGHT_GREEN);
                gfx.m_280168_().m_85849_();
            }
        }
    }

    @Nonnull
    public ItemStack getModule() {
        return this.module;
    }

    public boolean equals(ClickableModule other) {
        return this.module == other.getModule();
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean isInstalled() {
        return this.installed;
    }
}

