/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable.button;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import lehjr.numina.client.gui.clickable.Clickable;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.client.gui.geometry.Rect;
import lehjr.numina.client.render.IconUtils;
import lehjr.numina.common.string.StringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class VanillaButton
extends Clickable {
    List<Component> toolTip = new ArrayList<Component>();
    Component label;
    public static final int UNSET_FG_COLOR = -1;
    protected int packedFGColor = -1;
    float alpha = 1.0f;

    public VanillaButton(double left, double top, double width, Component label, boolean enabled) {
        super(new Rect(left, top, left + width, top + 20.0));
        this.label = label;
        this.setEnabled(enabled);
    }

    public VanillaButton(double left, double top, Component label, boolean enabled) {
        this(new MusePoint2D(left, top), label, enabled);
    }

    public VanillaButton(MusePoint2D ul, Component label, boolean enabled) {
        super(ul, MusePoint2D.ZERO, false);
        this.label = label;
        this.setWH(new MusePoint2D(StringUtils.getStringWidth(label.getString()) + 20.0, 20.0));
        this.setEnabled(enabled);
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        if (this.isVisible()) {
            this.renderButton(gfx, mouseX, mouseY, partialTick);
            this.renderBg(gfx, mouseX, mouseY, partialTick);
        }
    }

    public int getFGColor() {
        if (this.packedFGColor != -1) {
            return this.packedFGColor;
        }
        return this.isEnabled() ? 0xFFFFFF : 0xA0A0A0;
    }

    public void setToolTip(List<Component> toolTip) {
        this.toolTip = toolTip;
    }

    public float getAlpha() {
        return this.alpha;
    }

    protected int getYImage(boolean pIsHovered) {
        int i = 1;
        if (!this.isEnabled()) {
            i = 0;
        } else if (pIsHovered) {
            i = 2;
        }
        return i;
    }

    public void renderButton(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontrenderer = minecraft.f_91062_;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)AbstractWidget.f_93617_);
        int i = this.getYImage(this.containsPoint(mouseX, mouseY));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        IconUtils.INSTANCE.blit(gfx.m_280168_(), this.left(), this.top(), 0.0, 46 + i * 20, this.width() / 2.0, this.height());
        IconUtils.INSTANCE.blit(gfx.m_280168_(), this.left() + this.width() / 2.0, this.top(), 200.0 - this.width() / 2.0, 46 + i * 20, this.width() / 2.0, this.height());
        this.renderBg(gfx, mouseX, mouseY, partialTicks);
        int j = this.getFGColor();
        gfx.m_280653_(fontrenderer, this.getLabel(), (int)(this.left() + this.width() / 2.0), (int)(this.top() + (this.height() - 8.0) / 2.0), j | Mth.m_14167_((float)(this.alpha * 255.0f)) << 24);
    }

    protected void renderBg(GuiGraphics gfx, int pMouseX, int pMouseY, float frameTime) {
    }

    public void setLabel(Component label) {
        this.label = label;
    }

    public Component getLabel() {
        return this.label;
    }

    @Override
    public List<Component> getToolTip(int x, int y) {
        if (this.containsPoint(x, y)) {
            if (this.toolTip.isEmpty()) {
                return super.getToolTip(x, y);
            }
            return this.toolTip;
        }
        return null;
    }
}

