/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.clickable.slider;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import lehjr.numina.client.gui.clickable.Clickable;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.common.math.Color;
import lehjr.numina.common.math.MathUtils;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix4f;

public abstract class AbstractSlider
extends Clickable {
    public boolean keepKnobWithinBounds = true;
    String id = "";
    protected boolean isHorizontal;
    protected double tickVal = 0.0;
    protected boolean showTickLines = false;
    protected double sliderValue = 0.5;
    protected double minValue = 0.0;
    protected double maxValue = 1.0;
    public boolean dragging = false;
    protected double knobSize = 8.0;

    private AbstractSlider() {
        super(MusePoint2D.ZERO, MusePoint2D.ZERO);
        this.isHorizontal = false;
    }

    public AbstractSlider(double left, double top, double right, double bottom, String id, boolean isHorizontal) {
        super(left, top, right, bottom, false);
        this.isHorizontal = isHorizontal;
        this.id = id;
        this.calculateTickCoordinates();
    }

    public AbstractSlider(MusePoint2D ul, MusePoint2D br, String id, boolean isHorizontal) {
        super(ul, br, false);
        this.isHorizontal = isHorizontal;
        this.id = id;
        this.calculateTickCoordinates();
    }

    List<Double> calculateTickCoordinates() {
        ArrayList<Double> vals = new ArrayList<Double>();
        if (this.tickVal != 0.0) {
            for (double i = this.minValue + this.tickVal; i < this.maxValue; i += this.tickVal) {
                vals.add((this.isHorizontal ? this.left() : this.top()) + this.getSize() * MathUtils.clampDouble((i - this.minValue) / (this.maxValue - this.minValue), 0.0, 1.0));
            }
        }
        return vals;
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        if (this.isVisible() && this.isEnabled()) {
            this.renderBg(gfx, mouseX, mouseY, partialTick);
            if (this.showTickLines && this.tickVal != 0.0) {
                for (double val : this.calculateTickCoordinates()) {
                    this.drawSingleLine(gfx, val, this.top(), val, this.bottom(), Color.WHITE);
                }
            }
            this.renderKnob(gfx, mouseX, mouseY, partialTick);
        }
    }

    public abstract void renderBg(GuiGraphics var1, int var2, int var3, float var4);

    public abstract void renderKnob(GuiGraphics var1, int var2, int var3, float var4);

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            this.dragging = true;
            this.update(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public void setKnobSize(double knobSize) {
        this.knobSize = knobSize;
    }

    public double getKnobSize() {
        return this.knobSize;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.dragging) {
            this.update(mouseX, mouseY);
            this.dragging = false;
            return true;
        }
        return false;
    }

    public void setThickness(double thicknessIn) {
        if (this.isHorizontal) {
            this.setHeight(thicknessIn);
        } else {
            this.setWidth(thicknessIn);
        }
    }

    public double getThickness() {
        if (this.isHorizontal) {
            return this.height();
        }
        return this.width();
    }

    public void setSize(double size) {
        if (this.isHorizontal) {
            this.setWidth(size);
        } else {
            this.setHeight(size);
        }
    }

    public double getSize() {
        double retVal;
        double d = retVal = this.isHorizontal ? this.width() : this.height();
        if (this.keepKnobWithinBounds) {
            return retVal - this.getKnobSize();
        }
        return retVal;
    }

    public String id() {
        return this.id;
    }

    public void update(double mouseX, double mouseY) {
        if (this.isHorizontal) {
            this.setValueByMouse(mouseX);
        } else {
            this.setValueByMouse(mouseY);
        }
        if (Double.isNaN(this.sliderValue)) {
            this.sliderValue = 0.0;
        }
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public double getValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public double getSliderInternalValue() {
        return this.sliderValue;
    }

    public void setValue(double value) {
        if (value != 0.0 && this.tickVal != 0.0) {
            value -= value % this.tickVal;
        }
        this.sliderValue = MathUtils.clampDouble((value - this.minValue) / (this.maxValue - this.minValue), 0.0, 1.0);
    }

    public void setValueByMouse(double value) {
        this.sliderValue = this.isEnabled() && this.isVisible() && this.dragging ? (this.isHorizontal ? MathUtils.clampDouble((value - this.centerX()) / this.getSize() + 0.5, 0.0, 1.0) : MathUtils.clampDouble((value - this.centerY()) / this.getSize() + 0.5, 0.0, 1.0)) : MathUtils.clampDouble(this.sliderValue, 0.0, 1.0);
    }

    public double getMinVal() {
        return this.minValue;
    }

    public AbstractSlider setMinValue(double min) {
        this.minValue = min;
        return this;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public AbstractSlider setMaxValue(double max) {
        this.maxValue = max;
        return this;
    }

    void drawSingleLine(GuiGraphics gfx, double xStart, double yStart, double xEnd, double yEnd, Color color) {
        PoseStack poseStack = gfx.m_280168_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        this.preDraw(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        RenderSystem.lineWidth((float)1.0f);
        builder.m_252986_(matrix4f, (float)xStart, (float)yStart, this.getZLevel()).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        builder.m_252986_(matrix4f, (float)xEnd, (float)yEnd, this.getZLevel()).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        builder.m_231175_();
        this.postDraw(builder);
    }
}

