/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.client.gui.geometry;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.FloatBuffer;
import lehjr.numina.client.gui.geometry.GradientAndArcCalculator;
import lehjr.numina.client.gui.geometry.IDrawable;
import lehjr.numina.client.gui.geometry.IDrawableRect;
import lehjr.numina.client.gui.geometry.MusePoint2D;
import lehjr.numina.client.gui.geometry.Rect;
import lehjr.numina.common.math.Color;
import net.minecraft.client.gui.GuiGraphics;
import org.lwjgl.BufferUtils;

public class DrawableRect
extends Rect
implements IDrawableRect {
    Color backgroundColor;
    Color borderColor;
    Color backgroundColor2 = null;
    float cornerradius = 3.0f;
    public float zLevel = 1.0f;
    boolean shrinkBorder = true;

    public DrawableRect(double left, double top, double right, double bottom, boolean growFromMiddle, Color backgroundColor, Color borderColor) {
        super(left, top, right, bottom, growFromMiddle);
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
    }

    public DrawableRect(Rect ref, Color backgroundColor, Color borderColor) {
        super(ref.getUL(), ref.getWH());
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
    }

    public DrawableRect(double left, double top, double right, double bottom, Color backgroundColor, Color borderColor) {
        super(left, top, right, bottom, false);
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
    }

    public DrawableRect(MusePoint2D ul, MusePoint2D br, Color backgroundColor, Color borderColor) {
        super(ul, br);
        this.backgroundColor = backgroundColor;
        this.borderColor = borderColor;
    }

    @Override
    public float getZLevel() {
        return this.zLevel;
    }

    @Override
    public IDrawable setZLevel(float zLevelIn) {
        this.zLevel = zLevelIn;
        return this;
    }

    public void setShrinkBorder(boolean shrinkBorder) {
        this.shrinkBorder = shrinkBorder;
    }

    public DrawableRect setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public DrawableRect setSecondBackgroundColor(Color backgroundColor2In) {
        this.backgroundColor2 = backgroundColor2In;
        return this;
    }

    public DrawableRect setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public FloatBuffer preDraw(double shrinkBy) {
        return this.preDraw(this.left() + shrinkBy, this.top() + shrinkBy, this.right() - shrinkBy, this.bottom() - shrinkBy);
    }

    public FloatBuffer preDraw(double left, double top, double right, double bottom) {
        FloatBuffer corner = GradientAndArcCalculator.getArcPoints((float)Math.PI, 4.712389f, this.getCornerradius(), (float)(left + (double)this.getCornerradius()), (float)(top + (double)this.getCornerradius()));
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)(corner.limit() * 4));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(4.712389f, (float)Math.PI * 2, this.getCornerradius(), (float)(left + (double)this.getCornerradius()), (float)(bottom - (double)this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(0.0f, 1.5707964f, this.getCornerradius(), (float)(right - (double)this.getCornerradius()), (float)(bottom - (double)this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(1.5707964f, (float)Math.PI, this.getCornerradius(), (float)(right - (double)this.getCornerradius()), (float)(top + (double)this.getCornerradius()));
        vertices.put(corner);
        vertices.flip();
        return vertices;
    }

    public void drawBackground(GuiGraphics gfx, FloatBuffer vertices) {
        this.drawBuffer(gfx, vertices, this.backgroundColor, VertexFormat.Mode.TRIANGLE_FAN);
    }

    public void drawBackground(GuiGraphics gfx, FloatBuffer vertices, FloatBuffer colors) {
        this.drawBuffer(gfx, vertices, colors, VertexFormat.Mode.TRIANGLE_FAN);
    }

    public void drawBorder(GuiGraphics gfx, FloatBuffer vertices) {
        this.drawBuffer(gfx, vertices, this.borderColor, VertexFormat.Mode.DEBUG_LINE_STRIP);
    }

    void drawBuffer(GuiGraphics gfx, FloatBuffer vertices, Color color, VertexFormat.Mode glMode) {
        BufferBuilder builder = this.preDraw(glMode, DefaultVertexFormat.f_85815_);
        this.addVerticesToBuffer(builder, gfx.m_280168_().m_85850_().m_252922_(), vertices, color);
        this.postDraw(builder);
    }

    void drawBuffer(GuiGraphics gfx, FloatBuffer vertices, FloatBuffer colors, VertexFormat.Mode glMode) {
        BufferBuilder builder = this.preDraw(glMode, DefaultVertexFormat.f_85815_);
        this.addVerticesToBuffer(builder, gfx.m_280168_().m_85850_().m_252922_(), vertices, colors);
        this.postDraw(builder);
    }

    public float getCornerradius() {
        return this.cornerradius;
    }

    public DrawableRect setCornerradius(float cornerradiusIn) {
        this.cornerradius = cornerradiusIn;
        return this;
    }

    public FloatBuffer getVertices(double shrinkBy) {
        return this.getVertices(this.left() + shrinkBy, this.top() + shrinkBy, this.right() - shrinkBy, this.bottom() - shrinkBy);
    }

    public FloatBuffer getVertices(double left, double top, double right, double bottom) {
        FloatBuffer corner = GradientAndArcCalculator.getArcPoints((float)Math.PI, 4.712389f, this.getCornerradius(), (float)(left + (double)this.getCornerradius()), (float)(top + (double)this.getCornerradius()));
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)(corner.limit() * 4));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(4.712389f, (float)Math.PI * 2, this.getCornerradius(), (float)(left + (double)this.getCornerradius()), (float)(bottom - (double)this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(0.0f, 1.5707964f, this.getCornerradius(), (float)(right - (double)this.getCornerradius()), (float)(bottom - (double)this.getCornerradius()));
        vertices.put(corner);
        corner = GradientAndArcCalculator.getArcPoints(1.5707964f, (float)Math.PI, this.getCornerradius(), (float)(right - (double)this.getCornerradius()), (float)(top + (double)this.getCornerradius()));
        vertices.put(corner);
        vertices.flip();
        return vertices;
    }

    @Override
    public void preRender(GuiGraphics gfx, int mouseX, int mouseY, float frameTIme) {
        IDrawableRect.super.preRender(gfx, mouseX, mouseY, frameTIme);
    }

    @Override
    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        FloatBuffer vertices = this.preDraw(0.0);
        if (this.backgroundColor2 != null) {
            FloatBuffer colors = GradientAndArcCalculator.getColorGradient(this.backgroundColor, this.backgroundColor2, vertices.limit() * 4);
            this.drawBackground(gfx, vertices, colors);
        } else {
            this.drawBackground(gfx, vertices);
        }
        if (this.shrinkBorder) {
            vertices = this.preDraw(1.0);
        } else {
            vertices.rewind();
        }
        this.drawBorder(gfx, vertices);
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(super.toString());
        stringbuilder.append("Background Color: ").append(this.backgroundColor.toString()).append("\n");
        stringbuilder.append("Background Color 2: ").append(this.backgroundColor2 == null ? "null" : this.backgroundColor2.toString()).append("\n");
        stringbuilder.append("Border Color: ").append(this.borderColor.toString()).append("\n");
        return stringbuilder.toString();
    }
}

