/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.inventory.modechanging;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.common.capabilities.inventory.modularitem.ModularItem;
import lehjr.numina.common.capabilities.module.externalitems.IOtherModItemsAsModules;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.rightclick.IRightClickModule;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.network.NuminaPackets;
import lehjr.numina.common.network.packets.serverbound.ModeChangeRequestPacketServerBound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModeChangingModularItem
extends ModularItem
implements IModeChangingItem {
    protected static int activeMode = -1;

    public ModeChangingModularItem(@Nonnull ItemStack modularItem, int size) {
        this(modularItem, (NonNullList<ItemStack>)NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_));
    }

    public ModeChangingModularItem(@Nonnull ItemStack modularItem, NonNullList<ItemStack> stacks) {
        super(modularItem, stacks, true);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public BakedModel getInventoryModel() {
        return Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(this.getActiveModule());
    }

    @Override
    public List<Integer> getValidModes() {
        this.loadCapValues();
        ArrayList<Integer> moduleIndexes = new ArrayList<Integer>();
        for (int i = 1; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (!this.isValidMode(module)) continue;
            moduleIndexes.add(i);
        }
        return moduleIndexes;
    }

    boolean isValidMode(@Nonnull ItemStack module) {
        if (module.m_41619_()) {
            return false;
        }
        return module.getCapability(NuminaCapabilities.POWER_MODULE).map(m -> m.isAllowed() && (m instanceof IRightClickModule || m instanceof IOtherModItemsAsModules)).orElse(false);
    }

    @Override
    public boolean isValidMode(ResourceLocation mode) {
        for (int i = 1; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.m_41619_() || !ItemUtils.getRegistryName(module).equals((Object)mode) || !this.isValidMode(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getActiveModule() {
        int activeModeIndex = this.getActiveMode();
        ItemStack module = activeModeIndex != -1 ? this.getStackInSlot(activeModeIndex) : ItemStack.f_41583_;
        return module.getCapability(NuminaCapabilities.POWER_MODULE).map(m -> m.isAllowed() && (m instanceof IRightClickModule || m instanceof IOtherModItemsAsModules)).orElse(false) != false ? module : ItemStack.f_41583_;
    }

    @Override
    public boolean hasActiveModule(ResourceLocation regName) {
        ItemStack module;
        int activeModeIndex = this.getActiveMode();
        ItemStack itemStack = module = activeModeIndex != -1 ? this.getStackInSlot(activeModeIndex) : ItemStack.f_41583_;
        if (regName == ItemUtils.getRegistryName(module)) {
            return this.isModuleOnline(module);
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            if (i == activeModeIndex || (module = this.getStackInSlot(i)).m_41619_() || !ItemUtils.getRegistryName(module).equals((Object)regName)) continue;
            return this.isModuleOnline(module);
        }
        return false;
    }

    @Override
    public boolean isModuleOnline(ItemStack module) {
        return module.getCapability(NuminaCapabilities.POWER_MODULE).map(m -> {
            if (m.isAllowed() && m.isModuleOnline()) {
                if (m instanceof IRightClickModule) {
                    return m.getModuleStack().equals(this.getActiveModule(), false);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Override
    public int getActiveMode() {
        List<Integer> validModes;
        if (activeMode == -1 && !(validModes = this.getValidModes()).isEmpty()) {
            activeMode = validModes.get(0);
        }
        return activeMode;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack retStack = super.insertItem(slot, stack, simulate);
        if (retStack.m_41619_() && !simulate) {
            ItemStack stackInSlot = this.getStackInSlot(slot);
            CompoundTag tag = stackInSlot.m_41784_();
            stackInSlot.m_41751_(tag);
            super.setStackInSlot(slot, stackInSlot);
        }
        return retStack;
    }

    @Override
    public void setActiveMode(int newMode) {
        activeMode = newMode;
        this.onContentsChanged(newMode);
    }

    @Override
    public void cycleMode(Player player, int dMode) {
        List<Integer> modes = this.getValidModes();
        if (!modes.isEmpty()) {
            int newindex = ModeChangingModularItem.clampMode(modes.indexOf(this.getActiveMode()) + dMode, modes.size());
            int newmode = modes.get(newindex);
            NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new ModeChangeRequestPacketServerBound(newmode));
        }
    }

    @Override
    public int nextMode() {
        List<Integer> modes = this.getValidModes();
        if (!modes.isEmpty()) {
            int newindex = ModeChangingModularItem.clampMode(modes.indexOf(this.getActiveMode()) + 1, modes.size());
            return modes.get(newindex);
        }
        return -1;
    }

    @Override
    public int prevMode() {
        List<Integer> modes = this.getValidModes();
        if (!modes.isEmpty()) {
            int newindex = ModeChangingModularItem.clampMode(modes.indexOf(this.getActiveMode()) - 1, modes.size());
            return modes.get(newindex);
        }
        return -1;
    }

    private static int clampMode(int selection, int modesSize) {
        return selection > 0 ? selection % modesSize : (selection + modesSize * -selection) % modesSize;
    }

    @Override
    @Deprecated
    public boolean isModuleActiveAndOnline(ResourceLocation moduleName) {
        if (this.hasActiveModule(moduleName)) {
            return this.getActiveModule().getCapability(NuminaCapabilities.POWER_MODULE).map(IPowerModule::isModuleOnline).orElse(false);
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        int mode = this.getActiveMode();
        if (mode != -1) {
            tag.m_128405_("Mode", mode);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("Mode", 3)) {
            activeMode = nbt.m_128451_("Mode");
        }
        super.deserializeNBT(nbt);
    }
}

