/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.module.blockbreaking;

import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.event.entity.player.PlayerEvent;

public interface IBlockBreakingModule
extends IPowerModule {
    default public boolean canHarvestBlock(@Nonnull ItemStack stack, BlockState state, Player player, BlockPos pos, double playerEnergy) {
        return playerEnergy >= (double)this.getEnergyUsage() && this.isToolEffective((BlockGetter)player.m_9236_(), pos, this.getEmulatedTool());
    }

    public boolean mineBlock(@Nonnull ItemStack var1, Level var2, BlockState var3, BlockPos var4, LivingEntity var5, double var6);

    public void handleBreakSpeed(PlayerEvent.BreakSpeed var1);

    public int getEnergyUsage();

    @Nonnull
    public ItemStack getEmulatedTool();

    default public boolean isToolEffective(BlockGetter world, BlockPos pos, @Nonnull ItemStack emulatedTool) {
        BlockState state = world.m_8055_(pos);
        if (emulatedTool.m_41735_(state)) {
            return true;
        }
        if (Float.compare(state.m_60800_(world, pos), -1.0f) <= 0) {
            return false;
        }
        return emulatedTool.m_41720_().m_8096_(state);
    }

    default public boolean blockCheckAndHarvest(Player player, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block == null || world.m_46859_(pos) || block == Blocks.f_50752_) {
            return false;
        }
        if ((block instanceof IForgeShearable || block instanceof FlowerBlock || block instanceof BushBlock || block instanceof LeavesBlock) && block.canHarvestBlock(state, (BlockGetter)world, pos, player) || block == Blocks.f_50125_ || block == Blocks.f_50127_) {
            block.m_6240_(world, player, pos, state, world.m_7702_(pos), new ItemStack((ItemLike)Items.f_42384_));
            world.m_7471_(pos, false);
            return true;
        }
        return false;
    }
}

