/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.module.powermodule;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IConfigGetter;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.UnitMap;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IPowerModule
extends IConfigGetter {
    public ItemStack getModuleStack();

    public ModuleTarget getTarget();

    public ModuleCategory getCategory();

    default public int getTier() {
        return -1;
    }

    default public String getModuleGroup() {
        return "";
    }

    public void addTradeoffProperty(String var1, String var2, double var3);

    public void addPropertyModifier(String var1, IPropertyModifier var2);

    public void addTradeoffProperty(String var1, String var2, double var3, String var5);

    public void addBaseProperty(String var1, double var2);

    public void addBaseProperty(String var1, double var2, String var4);

    public double applyPropertyModifiers(String var1);

    public double applyPropertyModifiers(String var1, CompoundTag var2);

    public Map<String, List<IPropertyModifier>> getPropertyModifiers();

    public void addIntTradeoffProperty(String var1, String var2, int var3, String var4, int var5, int var6);

    public boolean isAllowed();

    default public boolean getGenericBooleanProperty(ImmutableList key, Callable<IConfig> config, boolean defBool) {
        return this.getConfig(config).map(iconfig -> iconfig.getGenericBooleanProperty((ImmutableList<String>)key)).orElse(defBool);
    }

    default public CompoundTag getModuleTag() {
        return TagUtils.getModuleTag(this.getModuleStack());
    }

    default public boolean isModuleOnline() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public String getUnit(@Nonnull String propertyName) {
        return UnitMap.MAP.getUnit(propertyName);
    }

    default public void addUnitLabel(@Nonnull String propertyName, String unit) {
        UnitMap.MAP.addUnitLabel(propertyName, unit);
    }

    public static class PropertyModifierLinearAdditive
    implements IPropertyModifier {
        public final String tradeoffName;
        public double defaultMultiplier;
        ImmutableList<String> configKey;
        Callable<IConfig> config;

        public PropertyModifierLinearAdditive(ImmutableList<String> configKey, Callable<IConfig> config, String tradeoffName, double defaultMultiplier) {
            this.defaultMultiplier = defaultMultiplier;
            this.tradeoffName = tradeoffName;
            this.configKey = configKey;
            this.config = config;
        }

        @Override
        public double applyModifier(CompoundTag moduleTag, double value) {
            double multiplier = this.getConfig(this.config).map(config -> config.getTradeoffPropertyDoubleOrDefault(this.configKey, this.defaultMultiplier)).orElse(this.defaultMultiplier);
            return value + multiplier * TagUtils.getDoubleOrZero(moduleTag, this.tradeoffName);
        }

        public String getTradeoffName() {
            return this.tradeoffName;
        }
    }

    public static class PropertyModifierIntLinearAdditive
    extends PropertyModifierLinearAdditive {
        protected int roundTo = 1;
        protected int offset = 0;

        public PropertyModifierIntLinearAdditive(ImmutableList<String> configKey, Callable<IConfig> config, String tradeoffName, double defaultMultiplier, int roundTo, int offset) {
            super(configKey, config, tradeoffName, defaultMultiplier);
            this.roundTo = roundTo;
            this.offset = offset;
        }

        @Override
        public double applyModifier(CompoundTag moduleTag, double value) {
            int multiplier = this.getConfig(this.config).map(config -> config.getTradeoffPropertyIntegerOrDefault((ImmutableList<String>)this.configKey, (int)this.defaultMultiplier)).orElse((int)this.defaultMultiplier);
            long result = (long)(value + (double)multiplier * TagUtils.getDoubleOrZero(moduleTag, this.tradeoffName));
            return this.roundWithOffset(result, this.roundTo, this.offset);
        }

        public double getScaledDouble(CompoundTag moduleTag, double value) {
            double scaledVal = this.applyModifier(moduleTag, value);
            double ret = (scaledVal - value) / this.defaultMultiplier;
            TagUtils.setDoubleOrRemove(moduleTag, this.tradeoffName, ret);
            return ret;
        }

        public long roundWithOffset(double input, int roundTo, int offset) {
            return Math.round((input + (double)offset) / (double)roundTo) * (long)roundTo - (long)offset;
        }

        public int getRoundTo() {
            return this.roundTo;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    public static class PropertyModifierFlatAdditive
    implements IPropertyModifier {
        ImmutableList<String> configKey;
        Callable<IConfig> config;
        double defaultVal;

        public PropertyModifierFlatAdditive(ImmutableList<String> configKey, Callable<IConfig> config, double baseVal) {
            this.configKey = configKey;
            this.config = config;
            this.defaultVal = baseVal;
        }

        @Override
        public double applyModifier(CompoundTag moduleTag, double value) {
            return value + this.getConfig(this.config).map(config -> config.getBasePropertyDoubleOrDefault(this.configKey, this.defaultVal)).orElse(this.defaultVal);
        }
    }

    public static interface IPropertyModifier
    extends IConfigGetter {
        public double applyModifier(CompoundTag var1, double var2);
    }
}

