/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.module.powermodule;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.tags.TagUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class PowerModule
implements IPowerModule {
    protected ItemStack module;
    protected final ModuleCategory category;
    protected final ModuleTarget target;
    protected Map<String, List<IPowerModule.IPropertyModifier>> propertyModifiers = new HashMap<String, List<IPowerModule.IPropertyModifier>>();
    Callable<IConfig> moduleConfigGetter;
    ImmutableList<String> isAllowedConfigKey;
    final String moduleName;
    final String categoryTitle;

    public PowerModule(@Nonnull ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> moduleConfigGetterIn) {
        this.module = module;
        this.category = category;
        this.target = target;
        this.moduleConfigGetter = moduleConfigGetterIn;
        this.moduleName = this.itemTranslationKeyToConfigKey();
        this.categoryTitle = category.getConfigTitle().trim().replaceAll(" ", "_");
        this.isAllowedConfigKey = this.getConfigKey("isAllowed");
    }

    @Override
    public ItemStack getModuleStack() {
        return this.module;
    }

    @Override
    public ModuleTarget getTarget() {
        return this.target;
    }

    @Override
    public ModuleCategory getCategory() {
        return this.category;
    }

    @Override
    public void addTradeoffProperty(String tradeoffName, String propertyName, double defaultMultiplier) {
        ImmutableList<String> configKey = this.getConfigKey(propertyName + "_" + tradeoffName + "_multiplier");
        this.addPropertyModifier(propertyName, new IPowerModule.PropertyModifierLinearAdditive(configKey, this.moduleConfigGetter, tradeoffName, defaultMultiplier));
    }

    @Override
    public void addPropertyModifier(String propertyName, IPowerModule.IPropertyModifier modifier) {
        List<IPowerModule.IPropertyModifier> modifiers = this.propertyModifiers.get(propertyName);
        if (modifiers == null) {
            modifiers = new LinkedList<IPowerModule.IPropertyModifier>();
        }
        modifiers.add(modifier);
        this.propertyModifiers.put(propertyName, modifiers);
    }

    @Override
    public void addTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit) {
        this.addUnitLabel(propertyName, unit);
        this.addTradeoffProperty(tradeoffName, propertyName, multiplier);
    }

    public void addSimpleTradeoff(String tradeoffName, String firstPropertyName, String firstUnits, double firstPropertyBase, double firstPropertyMultiplier, String secondPropertyName, String secondUnits, double secondPropertyBase, double secondPropertyMultiplier) {
        this.addBaseProperty(firstPropertyName, firstPropertyBase, firstUnits);
        this.addTradeoffProperty(tradeoffName, firstPropertyName, firstPropertyMultiplier);
        this.addBaseProperty(secondPropertyName, secondPropertyBase, secondUnits);
        this.addTradeoffProperty(tradeoffName, secondPropertyName, secondPropertyMultiplier);
    }

    @Override
    public void addBaseProperty(String propertyName, double baseVal) {
        ImmutableList<String> configKey = this.getConfigKey("base_" + propertyName);
        this.addPropertyModifier(propertyName, new IPowerModule.PropertyModifierFlatAdditive(configKey, this.moduleConfigGetter, baseVal));
    }

    @Override
    public void addBaseProperty(String propertyName, double baseVal, String unit) {
        this.addUnitLabel(propertyName, unit);
        this.addBaseProperty(propertyName, baseVal);
    }

    @Override
    public double applyPropertyModifiers(String propertyName) {
        return this.applyPropertyModifiers(propertyName, TagUtils.getModuleTag(this.module));
    }

    @Override
    public double applyPropertyModifiers(String propertyName, CompoundTag moduleTag) {
        double propertyValue = 0.0;
        if (this.propertyModifiers.containsKey(propertyName)) {
            Iterable propertyModifiersIterable = this.propertyModifiers.get(propertyName);
            for (IPowerModule.IPropertyModifier modifier : propertyModifiersIterable) {
                propertyValue = modifier.applyModifier(moduleTag, propertyValue);
            }
        }
        return propertyValue;
    }

    @Override
    public Map<String, List<IPowerModule.IPropertyModifier>> getPropertyModifiers() {
        return this.propertyModifiers;
    }

    @Override
    public void addIntTradeoffProperty(String tradeoffName, String propertyName, int defaultMultiplier, String unit, int roundTo, int offset) {
        ImmutableList<String> configKey = this.getConfigKey(propertyName + "_" + tradeoffName + "_multiplier");
        this.addUnitLabel(propertyName, unit);
        this.addPropertyModifier(propertyName, new IPowerModule.PropertyModifierIntLinearAdditive(configKey, this.moduleConfigGetter, tradeoffName, defaultMultiplier, roundTo, offset));
    }

    @Override
    public boolean isAllowed() {
        return this.getConfig(this.moduleConfigGetter).map(config -> config.isModuleAllowed(this.isAllowedConfigKey)).orElse(true);
    }

    public ImmutableList<String> getConfigKey(String entry) {
        return ImmutableList.of((Object)"Modules", (Object)this.categoryTitle, (Object)this.moduleName, (Object)entry);
    }

    String itemTranslationKeyToConfigKey() {
        ResourceLocation regName;
        String itemPrefix;
        String translationKey = this.module.m_41720_().m_5524_();
        if (translationKey.startsWith(itemPrefix = "item." + (regName = ForgeRegistries.ITEMS.getKey((Object)this.module.m_41720_())).m_135827_() + ".")) {
            translationKey = translationKey.substring(itemPrefix.length());
        }
        return translationKey.replace(".", "_");
    }
}

