/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.capabilities.render.modelspec;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.render.modelspec.NuminaModelSpecRegistry;
import lehjr.numina.common.capabilities.render.modelspec.PartSpecBase;
import lehjr.numina.common.math.Color;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;

public interface IJavaModelNBTParser {
    public static final int FULL_BRIGHTNESS = 0xF000F0;

    public ModelPart getRoot();

    default public void renderPart(CompoundTag tag, int[] colors, PoseStack poseStack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn) {
        PartSpecBase partSpec;
        if (colors.length == 0) {
            colors = new int[]{Color.WHITE.getARGBInt()};
        }
        if ((partSpec = NuminaModelSpecRegistry.getInstance().getPart(tag)) == null) {
            return;
        }
        int ix = partSpec.getColorIndex(tag);
        int partColor = ix < colors.length && ix >= 0 ? colors[ix] : -1;
        boolean glow = partSpec.getGlow(tag);
        poseStack.m_85836_();
        ModelPart part = this.getPart(partSpec.getPartName(), poseStack);
        Color color = new Color(partColor);
        if (part != null) {
            part.m_104290_(poseStack.m_85850_(), bufferIn, glow ? 0xF000F0 : packedLightIn, glow ? OverlayTexture.f_118083_ : packedOverlayIn, color.r, color.g, color.b, color.a);
        }
        poseStack.m_85849_();
    }

    public List<String> ignore();

    @Nullable
    default public ModelPart getPart(String path, PoseStack poseStack) {
        ModelPart part = this.getRoot();
        this.translateAndRotate(part, poseStack);
        if (part != null) {
            this.translateAndRotate(part, poseStack);
            if (path.contains(".") && part != null) {
                String[] splitPath = path.split("\\.");
                for (int i = 0; i < splitPath.length; ++i) {
                    if (this.ignore().contains(splitPath[i])) continue;
                    part = part.m_171324_(splitPath[i]);
                    this.translateAndRotate(part, poseStack);
                }
            } else {
                part = part.m_171324_(path);
                this.translateAndRotate(part, poseStack);
            }
        }
        return part;
    }

    default public void translateAndRotate(ModelPart part, PoseStack poseStack) {
        if (part != null) {
            part.m_104299_(poseStack);
        }
    }
}

